/*
 * Decompiled with CFR 0.152.
 */
package utils.vnc.utils;

import java.awt.event.KeyEvent;
import java.util.HashMap;

public class KeySymMapper {
    public static final int KS_BACKSPACE = 65288;
    public static final int KS_TAB = 65289;
    public static final int KS_LINEFEED = 65290;
    public static final int KS_CLEAR = 65291;
    public static final int KS_RETURN = 65293;
    public static final int KS_PAUSE = 65299;
    public static final int KS_SCROLL_LOCK = 65300;
    public static final int KS_SYS_REQ = 65301;
    public static final int KS_ESCAPE = 65307;
    public static final int KS_DELETE = 65535;
    public static final int KS_HOME = 65360;
    public static final int KS_LEFT = 65361;
    public static final int KS_UP = 65362;
    public static final int KS_RIGHT = 65363;
    public static final int KS_DOWN = 65364;
    public static final int KS_PRIOR = 65365;
    public static final int KS_PAGE_UP = 65365;
    public static final int KS_NEXT = 65366;
    public static final int KS_PAGE_DOWN = 65366;
    public static final int KS_END = 65367;
    public static final int KS_BEGIN = 65368;
    public static final int KS_SELECT = 65376;
    public static final int KS_PRINTSCREEN = 65377;
    public static final int KS_EXECUTE = 65378;
    public static final int KS_INSERT = 65379;
    public static final int KS_UNDO = 65381;
    public static final int KS_REDO = 65382;
    public static final int KS_MENU = 65383;
    public static final int KS_FIND = 65384;
    public static final int KS_CANCEL = 65385;
    public static final int KS_HELP = 65386;
    public static final int KS_BREAK = 65387;
    public static final int KS_MODE_SWITCH = 65406;
    public static final int KS_SCRIPT_SWITCH = 65406;
    public static final int KS_NUM_LOCK = 65407;
    public static final int KS_F1 = 65470;
    public static final int KS_F2 = 65471;
    public static final int KS_F3 = 65472;
    public static final int KS_F4 = 65473;
    public static final int KS_F5 = 65474;
    public static final int KS_F6 = 65475;
    public static final int KS_F7 = 65476;
    public static final int KS_F8 = 65477;
    public static final int KS_F9 = 65478;
    public static final int KS_F10 = 65479;
    public static final int KS_F11 = 65480;
    public static final int KS_F12 = 65481;
    public static final int KS_SHIFT_L = 65505;
    public static final int KS_SHIFT_R = 65506;
    public static final int KS_CTRL_L = 65507;
    public static final int KS_CTRL_R = 65508;
    public static final int KS_META_L = 65511;
    public static final int KS_META_R = 65512;
    public static final int KS_ALT_L = 65513;
    public static final int KS_ALT_R = 65514;
    public static final int KS_META = 65515;
    private static HashMap keyMap;
    private static HashMap reverseMap;
    private static HashMap leftKeyMap;
    private static HashMap rightKeyMap;

    public static int getKeySymForCode(KeyEvent e) {
        Integer result = (Integer)keyMap.get(new Integer(e.getKeyCode()));
        if (result != null) {
            return result;
        }
        if (e.getKeyLocation() == 2 ? (result = (Integer)leftKeyMap.get(new Integer(e.getKeyCode()))) != null : (result = (Integer)rightKeyMap.get(new Integer(e.getKeyCode()))) != null) {
            return result;
        }
        if (e.getKeyChar() == '\uffff' || e.getKeyChar() == '\u0000') {
            return e.getKeyCode();
        }
        return e.getKeyChar();
    }

    public static boolean isKeySym(int code) {
        return reverseMap.containsKey(new Integer(code));
    }

    public static int getCodeForKeySym(int sym) {
        return (Integer)reverseMap.get(new Integer(sym));
    }

    public static int getKeySymForCode(int code) {
        Integer result = (Integer)keyMap.get(new Integer(code));
        if (result != null) {
            return result;
        }
        result = (Integer)leftKeyMap.get(new Integer(code));
        if (result != null) {
            return result;
        }
        return code;
    }

    static {
        Integer sym;
        Integer event;
        Object[] keys;
        keyMap = new HashMap();
        reverseMap = new HashMap();
        leftKeyMap = new HashMap();
        rightKeyMap = new HashMap();
        keyMap.put(new Integer(8), new Integer(65288));
        keyMap.put(new Integer(9), new Integer(65289));
        keyMap.put(new Integer(13), new Integer(65290));
        keyMap.put(new Integer(12), new Integer(65291));
        keyMap.put(new Integer(10), new Integer(65293));
        keyMap.put(new Integer(19), new Integer(65299));
        keyMap.put(new Integer(145), new Integer(65300));
        keyMap.put(new Integer(27), new Integer(65307));
        keyMap.put(new Integer(127), new Integer(65535));
        keyMap.put(new Integer(36), new Integer(65360));
        keyMap.put(new Integer(37), new Integer(65361));
        keyMap.put(new Integer(38), new Integer(65362));
        keyMap.put(new Integer(39), new Integer(65363));
        keyMap.put(new Integer(40), new Integer(65364));
        keyMap.put(new Integer(33), new Integer(65365));
        keyMap.put(new Integer(34), new Integer(65366));
        keyMap.put(new Integer(35), new Integer(65367));
        keyMap.put(new Integer(65368), new Integer(65368));
        keyMap.put(new Integer(154), new Integer(65377));
        keyMap.put(new Integer(155), new Integer(65379));
        keyMap.put(new Integer(65483), new Integer(65381));
        keyMap.put(new Integer(65481), new Integer(65382));
        keyMap.put(new Integer(65488), new Integer(65384));
        keyMap.put(new Integer(3), new Integer(65385));
        keyMap.put(new Integer(156), new Integer(65386));
        keyMap.put(new Integer(144), new Integer(65407));
        keyMap.put(new Integer(112), new Integer(65470));
        keyMap.put(new Integer(113), new Integer(65471));
        keyMap.put(new Integer(114), new Integer(65472));
        keyMap.put(new Integer(115), new Integer(65473));
        keyMap.put(new Integer(116), new Integer(65474));
        keyMap.put(new Integer(117), new Integer(65475));
        keyMap.put(new Integer(118), new Integer(65476));
        keyMap.put(new Integer(119), new Integer(65477));
        keyMap.put(new Integer(120), new Integer(65478));
        keyMap.put(new Integer(121), new Integer(65479));
        keyMap.put(new Integer(122), new Integer(65480));
        keyMap.put(new Integer(123), new Integer(65481));
        leftKeyMap.put(new Integer(16), new Integer(65505));
        leftKeyMap.put(new Integer(17), new Integer(65507));
        leftKeyMap.put(new Integer(157), new Integer(65511));
        leftKeyMap.put(new Integer(18), new Integer(65513));
        rightKeyMap.put(new Integer(16), new Integer(65506));
        rightKeyMap.put(new Integer(17), new Integer(65508));
        rightKeyMap.put(new Integer(157), new Integer(65512));
        rightKeyMap.put(new Integer(157), new Integer(65515));
        rightKeyMap.put(new Integer(65406), new Integer(65514));
        for (Object key : keys = keyMap.keySet().toArray()) {
            event = (Integer)key;
            sym = (Integer)keyMap.get(event);
            reverseMap.put(sym, event);
        }
        for (Object key : keys = leftKeyMap.keySet().toArray()) {
            event = (Integer)key;
            sym = (Integer)leftKeyMap.get(event);
            reverseMap.put(sym, event);
        }
        for (Object key : keys = rightKeyMap.keySet().toArray()) {
            event = (Integer)key;
            sym = (Integer)rightKeyMap.get(event);
            reverseMap.put(sym, event);
        }
    }
}

