/*
 * Decompiled with CFR 0.152.
 */
package utils.udp.bidirectional;

import java.io.IOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import utils.stream.IpQuery;
import utils.udp.bidirectional.UDPListener;
import utils.udp.bidirectional.UDPReader;
import utils.udp.bidirectional.UDPResponder;
import utils.udp.util.UDPTTLUtil;
import utils.udp.util.UDPWrapUtil;

public class UDPClient
implements UDPResponder {
    DatagramSocket dsock;
    InetAddress addr;
    int port;
    UDPReader reader;
    UDPWrapUtil util = new UDPWrapUtil();
    UDPListener listener;

    @Override
    public String getHostFor(Object uid) {
        return this.addr.getHostAddress();
    }

    @Override
    public int getPortFor(Object uid) {
        return this.port;
    }

    public DatagramSocket getUnderlyingSocket() {
        return this.dsock;
    }

    @Override
    public String getSocketInfo() {
        return "" + this.dsock.getLocalPort();
    }

    public void switchUdpSocket() {
        System.out.println("[UDPClient] Trying to bind new replacement socket");
        try {
            DatagramSocket nsock;
            try {
                nsock = new DatagramSocket();
            }
            catch (BindException x) {
                System.out.println("[UDPClient] Unable to bind to wildcard address, trying LAN IP");
                nsock = new DatagramSocket(0, IpQuery.getOneLanIP());
            }
            this.reader.die();
            this.initReader(nsock);
            DatagramSocket doldsock = this.dsock;
            this.dsock = nsock;
            doldsock.close();
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    public void setTargetAddress(String addr, int port) throws UnknownHostException {
        this.addr = InetAddress.getByName(addr);
        this.port = port;
    }

    public UDPClient(String host, int port, UDPListener listener) throws IOException {
        this(host, port, listener, -1);
    }

    public UDPClient(String host, int port, UDPListener listener, int localport) throws IOException {
        if (localport == -1) {
            try {
                this.dsock = new DatagramSocket();
            }
            catch (BindException x) {
                System.out.println("[UDPClient] Unable to bind to wildcard address, trying LAN IP");
                this.dsock = new DatagramSocket(0, IpQuery.getOneLanIP());
            }
        } else {
            this.dsock = new DatagramSocket(localport);
        }
        this.listener = listener;
        this.addr = InetAddress.getByName(host);
        this.port = port;
        this.initReader(this.dsock);
    }

    private void initReader(DatagramSocket dgsock) {
        this.reader = new UDPReader(new Object(), dgsock, 4096, this.listener, this);
        this.reader.setPriority(10);
        this.reader.start();
    }

    public String toString() {
        return "UDPClient(" + this.getRemoteAddr() + ")";
    }

    public String getRemoteAddr() {
        return this.addr + ":" + this.port;
    }

    public int getLocalPort() {
        return this.dsock.getLocalPort();
    }

    public void dieButLeaveSocket() {
        try {
            this.reader.die();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void die() {
        try {
            this.dsock.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.dieButLeaveSocket();
    }

    public void setTTL(int ttl) {
        UDPTTLUtil.setTTL(this.dsock, ttl);
    }

    public void send(byte[] dat) throws IOException {
        this.send(dat, null);
    }

    @Override
    public void send(byte[] dat, Object uid) throws IOException {
        this.send(dat, 0, dat.length, uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(byte[] dat, int off, int len, Object uid) throws IOException {
        UDPWrapUtil uDPWrapUtil = this.util;
        synchronized (uDPWrapUtil) {
            DatagramPacket dp = this.util.wrap(dat, off, len);
            dp.setAddress(this.addr);
            dp.setPort(this.port);
            this.dsock.send(dp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendUnwrapped(byte[] dat, int off, int len, Object uid) throws IOException {
        UDPWrapUtil uDPWrapUtil = this.util;
        synchronized (uDPWrapUtil) {
            DatagramPacket dp = new DatagramPacket(dat, off, len);
            dp.setAddress(this.addr);
            dp.setPort(this.port);
            this.dsock.send(dp);
        }
    }
}

