/*
 * Decompiled with CFR 0.152.
 */
package utils.sync;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

public class QueuedBlockingMap {
    private Object mutex_LOCK = new Object();
    private int mutex_val = 1;
    public HashMap pool = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mutex_lock() throws InterruptedException {
        Object object = this.mutex_LOCK;
        synchronized (object) {
            --this.mutex_val;
            if (this.mutex_val < 0) {
                try {
                    this.mutex_LOCK.wait();
                }
                catch (InterruptedException e) {
                    ++this.mutex_val;
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mutex_release() {
        Object object = this.mutex_LOCK;
        synchronized (object) {
            ++this.mutex_val;
            if (this.mutex_val > 1) {
                this.mutex_val = 1;
            }
            if (this.mutex_val <= 0) {
                this.mutex_LOCK.notify();
            }
        }
    }

    public ArrayList getAllData() throws Exception {
        this.mutex_lock();
        ArrayList stuff = new ArrayList();
        for (Lock lock : this.pool.values()) {
            stuff.addAll(lock.messages);
        }
        this.mutex_release();
        return stuff;
    }

    private void removeLock(Object key) {
        this.pool.remove(key);
    }

    private Lock getLock(Object key) {
        Lock notifier = (Lock)this.pool.get(key);
        if (notifier == null) {
            notifier = new Lock();
            this.pool.put(key, notifier);
        }
        return notifier;
    }

    private void removeRecipient(Recipient recipient) {
        Object key = recipient.key;
        Lock tmp = this.getLock(key);
        tmp.recipients.remove(recipient);
        if (tmp.isEmpty()) {
            this.removeLock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, Object value) throws InterruptedException {
        this.mutex_lock();
        Lock notifier = this.getLock(key);
        if (notifier.recipients.size() > 0) {
            Recipient recipient;
            Recipient recipient2 = recipient = (Recipient)notifier.recipients.getFirst();
            synchronized (recipient2) {
                recipient.value = value;
                this.removeRecipient(recipient);
                this.mutex_release();
                recipient.notify();
            }
        } else {
            notifier.messages.addLast(value);
            this.mutex_release();
        }
    }

    public Object get(String keylist) throws InterruptedException {
        return this.get(keylist, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String keylist, long timeout) throws InterruptedException {
        Recipient recipient = new Recipient();
        recipient.key = keylist;
        recipient.value = null;
        boolean timed_out = false;
        this.mutex_lock();
        Lock lock = this.getLock(keylist);
        if (lock.messages.size() > 0) {
            recipient.value = lock.messages.removeFirst();
            if (lock.isEmpty()) {
                this.removeLock(keylist);
            }
        }
        if (recipient.value == null) {
            Recipient recipient2;
            try {
                recipient2 = recipient;
                synchronized (recipient2) {
                    lock = this.getLock(keylist);
                    lock.recipients.add(recipient);
                    this.mutex_release();
                    recipient.wait(timeout);
                }
            }
            catch (InterruptedException e) {
                this.mutex_lock();
                Recipient recipient3 = recipient;
                synchronized (recipient3) {
                    this.removeRecipient(recipient);
                    this.mutex_release();
                    throw e;
                }
            }
            this.mutex_lock();
            recipient2 = recipient;
            synchronized (recipient2) {
                if (recipient.value == null) {
                    timed_out = true;
                    this.removeRecipient(recipient);
                }
            }
            this.mutex_release();
        } else {
            this.mutex_release();
        }
        if (timed_out) {
            throw new InterruptedException("Timed out (" + timeout + "ms)");
        }
        return recipient.value;
    }

    class Lock {
        LinkedList messages = new LinkedList();
        LinkedList recipients = new LinkedList();

        Lock() {
        }

        public boolean isEmpty() {
            return this.messages.size() == 0 && this.recipients.size() == 0;
        }
    }

    class Recipient {
        Object key;
        Object value;
    }
}

