/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.utils.shadowlabel;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;

public final class Effects {
    public static final int TEXT_SHADOW_SIZE = 2;

    private Effects() {
    }

    public static void setAlpha(Graphics g, float alpha) {
        g.setColor(new Color(0, 0, 0, Math.round(255.0f * alpha)));
    }

    public static Color removeAlpha(Color c) {
        if (c.getAlpha() != 100) {
            c = new Color(c.getRGB());
        }
        return c;
    }

    public static void paintTextEffect(Graphics2D g, String s, Color c, int size, double tx, double ty, boolean isShadow) {
        Effects.prepareGraphics(g);
        float opacity = 0.8f;
        Composite oldComposite = g.getComposite();
        Color oldColor = g.getColor();
        float preAlpha = 0.4f;
        if (oldComposite instanceof AlphaComposite && ((AlphaComposite)oldComposite).getRule() == 3) {
            preAlpha = Math.min(((AlphaComposite)oldComposite).getAlpha(), preAlpha);
        }
        g.setColor(c);
        g.translate(tx, ty);
        int maxSize = isShadow ? size - 1 : size;
        for (int i = -size; i <= maxSize; ++i) {
            for (int j = -size; j <= maxSize; ++j) {
                double distance = i * i + j * j;
                float alpha = 0.8f;
                if (distance > 0.0) {
                    alpha = (float)(1.0 / (distance * (double)size * (double)0.8f));
                }
                if ((alpha *= preAlpha) > 1.0f) {
                    alpha = 1.0f;
                }
                g.setComposite(AlphaComposite.getInstance(3, alpha));
                g.drawString(s, i + size, j + size);
            }
        }
        g.translate(-tx, -ty);
        g.setComposite(oldComposite);
        g.setColor(oldColor);
        g.drawString(s, 0, 0);
    }

    private static void prepareGraphics(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    public static void paintTextShadow(Graphics2D g, String s, Color c) {
        Effects.paintTextEffect(g, s, Effects.removeAlpha(c), 2, -2.0, -1.0, true);
    }

    public static void paintTextShadow(Graphics2D g, String s, Color c, boolean down) {
        if (down) {
            Effects.paintTextEffect(g, s, Effects.removeAlpha(c), 2, -2.0, -1.0, true);
        } else {
            Effects.paintTextEffect(g, s, Effects.removeAlpha(c), 2, -2.0, -3.0, true);
        }
    }

    public static void paintTextShadow(Graphics2D g, String s) {
        Effects.paintTextShadow(g, s, Color.BLACK);
    }

    public static void paintTextShadow(Graphics2D g, String s, boolean down) {
        Effects.paintTextShadow(g, s, Color.BLACK, down);
    }

    public static void paintTextGlow(Graphics2D g, String s, Color glow) {
        Effects.paintTextEffect(g, s, Effects.removeAlpha(glow), 2, -2.0, -2.0, false);
    }

    public static class GradientPainter {
        private Color c1;
        private Color c2;
        private GradientPaint paint;
        private boolean cyclic = false;

        public GradientPainter(JComponent c) {
            this(c, c.getBackground(), c.getBackground().darker().darker());
        }

        public GradientPainter(JComponent c, Color c1, Color c2) {
            this.c1 = c1;
            this.c2 = c2;
            c.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    GradientPainter.this.paint = null;
                }
            });
        }

        public void setColors(Color c1, Color c2) {
            this.c1 = c1;
            this.c2 = c2;
            this.paint = null;
        }

        public void setCyclic(boolean cyclic) {
            this.cyclic = cyclic;
            this.paint = null;
        }

        public void paint(Graphics g, JComponent c) {
            if (this.paint == null) {
                this.paint = new GradientPaint(0.0f, 0.0f, this.c1, 0.0f, c.getHeight(), this.c2, this.cyclic);
            }
            ((Graphics2D)g).setPaint(this.paint);
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
    }
}

