/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.utils;

import java.util.Stack;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import utils.swing.utils.TreeState;

class StaticSaveStateThread
implements Runnable {
    JTree tree;
    TreeState state;

    public StaticSaveStateThread(JTree tree, TreeState state) {
        this.tree = tree;
        this.state = state;
    }

    @Override
    public void run() {
        this.state.selection = this.tree.getSelectionPaths();
        Stack stack = new Stack();
        if (this.tree.getModel().getRoot() != null) {
            this.saveExpanded(this.state, stack, this.tree, this.tree.getModel(), this.tree.getModel().getRoot());
        }
    }

    private void saveExpanded(TreeState state, Stack stack, JTree tree, TreeModel model, Object o) {
        stack.push(o);
        TreePath path = new TreePath(stack.toArray());
        if (tree.isExpanded(path)) {
            if (!state.expanded.contains(path)) {
                state.expanded.add(path);
            }
        } else if (state.expanded.contains(path)) {
            state.expanded.remove(path);
        }
        int len = model.getChildCount(o);
        for (int i = 0; i < len; ++i) {
            Object child = model.getChild(o, i);
            this.saveExpanded(state, stack, tree, model, child);
        }
        stack.pop();
    }

    public Object getState() {
        return this.state;
    }
}

