/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.tree;

import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;

public class IconNode
extends DefaultMutableTreeNode {
    Icon i = null;
    protected boolean useOwnIcon = false;

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof IconNode)) {
            return false;
        }
        IconNode node = (IconNode)object;
        if (this.userObject != null && !this.userObject.equals(node.userObject)) {
            return false;
        }
        return this.allowsChildren == node.allowsChildren;
    }

    public IconNode() {
        this(null);
    }

    public IconNode(Object userObject) {
        this(userObject, true, false);
    }

    public IconNode(Object userObject, boolean isSelected) {
        this(userObject, true, isSelected);
    }

    public IconNode(Object userObject, boolean allowsChildren, boolean isSelected) {
        super(userObject, allowsChildren);
    }

    public void setIcon(Icon newi) {
        this.i = newi;
        this.useOwnIcon = true;
    }

    public Icon getIcon() {
        return this.i;
    }

    public boolean getUseOwnIcon() {
        return this.useOwnIcon;
    }

    public void setUseOwnIcon(boolean b) {
        this.useOwnIcon = b;
    }

    public int searchForUserObjectOrInsertionPoint(Object o) {
        if (this.children == null) {
            return -1;
        }
        return Collections.binarySearch(this.children, o, new UserObjectComparator(null));
    }

    public int searchForUserObjectOrInsertionPoint(Object o, Comparator comp) {
        return Collections.binarySearch(this.children, o, new UserObjectComparator(comp));
    }

    public IconNode getChildByUserObject(Object o) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            IconNode tmp = (IconNode)this.getChildAt(i);
            if (!tmp.getUserObject().equals(o)) continue;
            return tmp;
        }
        return null;
    }

    public Vector getChildrenVector() {
        return this.children;
    }

    private class UserObjectComparator
    implements Comparator {
        Comparator objectComparator;

        public UserObjectComparator(Comparator objComp) {
            this.objectComparator = objComp;
        }

        public int compare(Object x1, Object x2) {
            Object o1 = x1;
            Object o2 = x2;
            if (x1 instanceof IconNode) {
                o1 = ((IconNode)x1).userObject;
            }
            if (x2 instanceof IconNode) {
                o2 = ((IconNode)x2).userObject;
            }
            if (this.objectComparator == null) {
                return o1.toString().compareTo(o2.toString());
            }
            return this.objectComparator.compare(o1, o2);
        }
    }
}

