/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import utils.swing.tree.IconCheckNode;
import utils.swing.tree.IconNode;

public class CheckRenderer
extends JPanel
implements TreeCellRenderer {
    protected JCheckBox check;
    protected TreeLabel label;
    boolean isIconNode = false;
    boolean isCheckNode = false;
    DefaultMutableTreeNode node = null;
    public static final int FILLED_BOX = 0;
    public static final int ALPHA_BOX = 1;
    public static final int LINE_BOX = 2;
    private int vertical_offset = 0;
    private int selection_type = 0;

    public CheckRenderer(int selection_type, int vertical_offset) {
        this();
        this.selection_type = selection_type;
        this.vertical_offset = vertical_offset;
    }

    public CheckRenderer() {
        this.setLayout(null);
        this.check = new JCheckBox();
        this.label = new TreeLabel();
        this.check.setBackground(UIManager.getColor("Tree.textBackground"));
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.isIconNode = false;
        this.isCheckNode = false;
        if (value instanceof IconNode) {
            this.isIconNode = true;
        }
        if (value instanceof IconCheckNode) {
            this.isCheckNode = true;
        }
        String stringValue = tree.convertValueToText(value, isSelected, expanded, leaf, row, hasFocus);
        if (this.isCheckNode) {
            this.setEnabled(tree.isEnabled());
            this.check.setSelected(((IconCheckNode)value).isSelected());
        }
        this.label.setFont(tree.getFont());
        this.label.setText(stringValue);
        this.label.setSelected(isSelected);
        this.label.setFocus(hasFocus);
        if (this.isIconNode) {
            Icon label_icon = ((IconNode)value).getIcon();
            this.label.setIcon(label_icon);
        }
        if (!this.isIconNode) {
            if (leaf) {
                this.label.setIcon(UIManager.getIcon("Tree.leafIcon"));
            } else if (expanded) {
                this.label.setIcon(UIManager.getIcon("Tree.openIcon"));
            } else {
                this.label.setIcon(UIManager.getIcon("Tree.closedIcon"));
            }
        }
        this.removeAll();
        if (this.isCheckNode) {
            this.add(this.check);
        }
        this.add(this.label);
        return this;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d_check = this.check.getPreferredSize();
        Dimension d_label = this.label.getPreferredSize();
        return new Dimension(d_check.width + d_label.width, d_check.height < d_label.height ? d_label.height : d_check.height);
    }

    @Override
    public void doLayout() {
        Dimension d_check = this.check.getPreferredSize();
        Dimension d_label = this.label.getPreferredSize();
        int y_check = 0;
        int y_label = 0;
        if (d_check.height < d_label.height) {
            y_check = (d_label.height - d_check.height) / 2;
        } else {
            y_label = (d_check.height - d_label.height) / 2;
        }
        if (this.isCheckNode) {
            this.check.setLocation(0, y_check);
            this.check.setBounds(0, y_check, d_check.width, d_check.height);
            this.label.setLocation(d_check.width, y_label);
            this.label.setBounds(d_check.width, y_label, d_label.width, d_label.height - this.vertical_offset);
        } else {
            this.label.setLocation(0, y_label);
            this.label.setBounds(0, y_label, d_label.width, d_label.height - this.vertical_offset);
        }
    }

    @Override
    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    class TreeLabel
    extends JLabel {
        boolean isSelected;
        boolean hasFocus;

        @Override
        public void setBackground(Color color) {
            if (color instanceof ColorUIResource) {
                color = null;
            }
            super.setBackground(color);
        }

        @Override
        public void paint(Graphics g) {
            boolean drawAlpha = false;
            int imageOffset = 0;
            Dimension d = this.getPreferredSize();
            String str = this.getText();
            if (str != null && 0 < str.length()) {
                if (this.isSelected) {
                    g.setColor(UIManager.getColor("Tree.selectionBackground"));
                    CheckRenderer.this.label.setForeground(UIManager.getColor("Tree.selectionForeground"));
                } else {
                    g.setColor(UIManager.getColor("Tree.textBackground"));
                    CheckRenderer.this.label.setForeground(UIManager.getColor("Tree.textForeground"));
                }
                Icon currentI = this.getIcon();
                if (currentI != null) {
                    imageOffset = currentI.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
                }
                if (!this.isSelected || CheckRenderer.this.selection_type == 0) {
                    g.fillRect(imageOffset, 0, d.width - 1 - imageOffset, d.height);
                } else if (CheckRenderer.this.selection_type == 1) {
                    drawAlpha = true;
                } else if (CheckRenderer.this.selection_type == 2) {
                    g.drawRect(imageOffset, 0, d.width - 1 - imageOffset, d.height);
                }
            }
            if (drawAlpha) {
                Color old = UIManager.getColor("Tree.textForeground");
                Color x = UIManager.getColor("Tree.selectionBackground");
                g.setColor(new Color(x.getRed(), x.getGreen(), x.getBlue(), 128));
                g.fillRect(imageOffset, 0, d.width - 1 - imageOffset, d.height);
                g.setColor(old);
                CheckRenderer.this.label.setForeground(old);
            }
            super.paint(g);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension retDimension = super.getPreferredSize();
            if (retDimension != null) {
                retDimension = new Dimension(retDimension.width + 3, retDimension.height);
            }
            return retDimension;
        }

        void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }

        void setFocus(boolean hasFocus) {
            this.hasFocus = hasFocus;
        }
    }
}

