/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.simplelist.jlist;

import java.awt.EventQueue;
import java.util.ArrayList;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.listener.ListEvent;
import utils.swing.simplelist.listener.ListListener;

public class SimpleListModel<T>
implements ListModel {
    private SimpleList<T> list;
    private final ArrayList<ListDataListener> listeners = new ArrayList();

    public SimpleListModel(SimpleList<T> list) {
        this.list = list;
        list.addListListener(new SimpleListListener());
    }

    public SimpleList<T> getUnderlyingList() {
        return this.list;
    }

    public T getElementAt(int index) {
        this.list.getLock().getReadLock();
        try {
            T t = this.list.get(index);
            return t;
        }
        finally {
            this.list.getLock().releaseReadLock();
        }
    }

    @Override
    public int getSize() {
        this.list.getLock().getReadLock();
        try {
            int n = this.list.size();
            return n;
        }
        finally {
            this.list.getLock().releaseReadLock();
        }
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    protected void fireListDataEvent(ListDataEvent listDataEvent) {
        for (ListDataListener listDataListener : this.listeners) {
            switch (listDataEvent.getType()) {
                case 0: {
                    listDataListener.contentsChanged(listDataEvent);
                    break;
                }
                case 1: {
                    listDataListener.intervalAdded(listDataEvent);
                    break;
                }
                case 2: {
                    listDataListener.intervalRemoved(listDataEvent);
                }
            }
        }
    }

    class EventFirer
    implements Runnable {
        private ListDataEvent lde;

        public EventFirer(ListDataEvent lde) {
            this.lde = lde;
        }

        @Override
        public void run() {
            SimpleListModel.this.fireListDataEvent(this.lde);
        }
    }

    class SimpleListListener
    implements ListListener {
        SimpleListListener() {
        }

        public void listAltered(ListEvent event) {
            int startIndex = event.getBlockStart();
            int endIndex = event.getBlockEnd();
            int type = 1;
            switch (event.getBlockType()) {
                case 0: {
                    type = 1;
                    break;
                }
                case 1: {
                    type = 2;
                    break;
                }
                case 2: {
                    type = 0;
                }
            }
            ListDataEvent lde = new ListDataEvent(SimpleListModel.this, type, startIndex, endIndex);
            if (EventQueue.isDispatchThread()) {
                SimpleListModel.this.fireListDataEvent(lde);
            } else {
                try {
                    SwingUtilities.invokeLater(new EventFirer(lde));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

