/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.simplelist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import utils.swing.simplelist.EventList;
import utils.swing.simplelist.SimpleLock;
import utils.swing.simplelist.listener.ListListener;
import utils.swing.simplelist.listener.SimpleEventManager;

public class SimpleList<T>
implements EventList<T> {
    protected ArrayList<T> list;
    protected SimpleEventManager<T> manager = new SimpleEventManager();
    protected SimpleLock lock;
    private boolean isBatch = false;
    private Comparator<T> comparator = null;

    public SimpleList() {
        this(null);
    }

    public SimpleList(Comparator<T> comparator) {
        this.comparator = comparator;
        this.list = new ArrayList();
        this.lock = new SimpleLock();
    }

    public String toString() {
        return this.list.toString();
    }

    public Object clone() {
        this.lock.getReadLock();
        try {
            SimpleList<T> clone = new SimpleList<T>(this.comparator);
            clone.list = (ArrayList)this.list.clone();
            SimpleList<T> simpleList = clone;
            return simpleList;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public SimpleLock getLock() {
        return this.lock;
    }

    @Override
    public boolean add(T e) {
        boolean result = false;
        if (!this.isBatch) {
            this.manager.start();
            this.lock.getReadWriteLock();
        }
        try {
            this.manager.queueInsertEvent(this.list.size(), e);
            result = this.list.add(e);
        }
        finally {
            if (!this.isBatch) {
                this.lock.releaseReadWriteLock();
                this.manager.end();
            }
        }
        return result;
    }

    @Override
    public void startBatch() {
        this.manager.start();
        this.lock.getReadWriteLock();
        this.isBatch = true;
    }

    @Override
    public void endBatch() {
        try {
            this.lock.releaseReadWriteLock();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
        this.manager.end();
        this.isBatch = false;
    }

    @Override
    public void add(int index, T element) {
        if (!this.isBatch) {
            this.manager.start();
            this.lock.getReadWriteLock();
        }
        try {
            this.manager.queueInsertEvent(index, element);
            this.list.add(index, element);
        }
        finally {
            if (!this.isBatch) {
                this.lock.releaseReadWriteLock();
                this.manager.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateAll(Collection<? extends T> c) {
        if (c.size() == 0) {
            return true;
        }
        if (!this.isBatch) {
            this.manager.start();
            this.lock.getReadWriteLock();
        }
        try {
            for (T o : c) {
                int index = this.indexOf(o);
                if (index < 0) continue;
                this.set(index, o);
            }
        }
        finally {
            if (!this.isBatch) {
                this.lock.releaseReadWriteLock();
                this.manager.end();
            }
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.addAll(this.size(), c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        if (c.size() == 0) {
            return true;
        }
        if (!this.isBatch) {
            this.manager.start();
            this.lock.getReadWriteLock();
        }
        try {
            for (T o : c) {
                this.manager.queueInsertEvent(index, o);
                this.list.add(index++, o);
            }
        }
        finally {
            if (!this.isBatch) {
                this.lock.releaseReadWriteLock();
                this.manager.end();
            }
        }
        return true;
    }

    @Override
    public void clear() {
        if (!this.isBatch) {
            this.manager.start();
            this.lock.getReadWriteLock();
        }
        try {
            for (int i = this.list.size() - 1; i >= 0; --i) {
                T removedElement = this.list.get(i);
                this.manager.queueRemoveEvent(i, removedElement);
                this.list.remove(i);
            }
        }
        finally {
            if (!this.isBatch) {
                this.lock.releaseReadWriteLock();
                this.manager.end();
            }
        }
    }

    @Override
    public boolean contains(Object o) {
        this.lock.getReadLock();
        try {
            boolean bl = this.list.contains(o);
            return bl;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.lock.getReadLock();
        try {
            boolean bl = this.list.containsAll(c);
            return bl;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    public T get(int index) {
        this.lock.getReadLock();
        try {
            T t = this.list.get(index);
            return t;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    public int indexOf(Object o) {
        this.lock.getReadLock();
        try {
            int n = this.list.indexOf(o);
            return n;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.lock.getReadLock();
        try {
            boolean bl = this.list.isEmpty();
            return bl;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        this.lock.getReadLock();
        try {
            int n = this.list.lastIndexOf(o);
            return n;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.list.listIterator(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        boolean result;
        if (!this.isBatch) {
            this.manager.start();
            this.lock.getReadWriteLock();
        }
        try {
            int index = this.list.indexOf(o);
            if (index == -1) {
                boolean bl = false;
                return bl;
            }
            this.manager.queueRemoveEvent(index, o);
            result = this.list.remove(o);
        }
        finally {
            if (!this.isBatch) {
                this.lock.releaseReadWriteLock();
                this.manager.end();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeAndGetIndex(Object o) {
        if (!this.isBatch) {
            this.manager.start();
            this.lock.getReadWriteLock();
        }
        try {
            int index = this.list.indexOf(o);
            if (index == -1) {
                int n = -1;
                return n;
            }
            this.manager.queueRemoveEvent(index, o);
            this.list.remove(index);
            int n = index;
            return n;
        }
        finally {
            if (!this.isBatch) {
                this.lock.releaseReadWriteLock();
                this.manager.end();
            }
        }
    }

    @Override
    public T remove(int index) {
        if (!this.isBatch) {
            this.manager.start();
            this.lock.getReadWriteLock();
        }
        T result = null;
        try {
            result = this.list.get(index);
            this.manager.queueRemoveEvent(index, result);
            this.list.remove(result);
        }
        finally {
            if (!this.isBatch) {
                this.lock.releaseReadWriteLock();
                this.manager.end();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        if (c.size() == 0) {
            return true;
        }
        if (!this.isBatch) {
            this.manager.start();
            this.lock.getReadWriteLock();
        }
        try {
            for (Object o : c) {
                int index = this.list.indexOf(o);
                if (index == -1) continue;
                this.manager.queueRemoveEvent(index, o);
                this.list.remove(o);
            }
        }
        finally {
            if (!this.isBatch) {
                this.lock.releaseReadWriteLock();
                this.manager.end();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        if (!this.isBatch) {
            this.manager.start();
            this.lock.getReadWriteLock();
        }
        try {
            for (int i = 0; i < this.list.size(); ++i) {
                T o = this.list.get(i);
                if (c.contains(o)) continue;
                this.manager.queueRemoveEvent(i, o);
                this.list.remove(i);
            }
        }
        finally {
            if (!this.isBatch) {
                this.lock.releaseReadWriteLock();
                this.manager.end();
            }
        }
        return true;
    }

    public void notifyElementUpdate(T element) {
        if (!this.isBatch) {
            this.manager.start();
            this.lock.getReadLock();
        }
        try {
            int index = this.indexOf(element);
            if (index != -1) {
                this.manager.queueUpdateEvent(index, element);
            }
        }
        finally {
            if (!this.isBatch) {
                this.lock.releaseReadLock();
                this.manager.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T set(int index, T element) {
        T oldElement = this.list.get(index);
        if (!this.isBatch) {
            this.manager.start();
            this.lock.getReadWriteLock();
        }
        try {
            this.manager.queueUpdateEvent(index, element);
            this.list.set(index, element);
        }
        finally {
            if (!this.isBatch) {
                this.lock.releaseReadWriteLock();
                this.manager.end();
            }
        }
        return oldElement;
    }

    @Override
    public int size() {
        this.lock.getReadLock();
        try {
            int n = this.list.size();
            return n;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        this.lock.getReadLock();
        try {
            List<T> list = this.list.subList(fromIndex, toIndex);
            return list;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    public Object[] toArray() {
        this.lock.getReadLock();
        try {
            Object[] objectArray = this.list.toArray();
            return objectArray;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    public <X> X[] toArray(X[] a) {
        this.lock.getReadLock();
        try {
            X[] XArray = this.list.toArray(a);
            return XArray;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void debugDump(String tab) {
        for (int i = 0; i < this.size(); ++i) {
            System.out.println(tab + i + ") " + this.get(i));
        }
    }

    @Override
    public void addListListener(ListListener l) {
        this.manager.addListListener(l);
    }

    @Override
    public void removeListListener(ListListener l) {
        this.manager.removeListListener(l);
    }

    public void setListContents(T[] array) {
        this.setListContents(Arrays.asList(array));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListContents(List<T> newContents) {
        if (newContents == null || newContents.size() == 0) {
            this.clear();
            return;
        }
        this.startBatch();
        try {
            int size = this.size();
            while (size > newContents.size()) {
                this.remove(--size);
            }
            for (int i = 0; i < newContents.size(); ++i) {
                T newEntry = newContents.get(i);
                if (this.size() > i) {
                    this.set(i, newEntry);
                    continue;
                }
                this.add(newEntry);
            }
        }
        finally {
            this.endBatch();
        }
    }

    public boolean isInBatchMode() {
        return this.isBatch;
    }
}

