/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.png;

import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.imageio.ImageIO;
import utils.stream.GZIPer;
import utils.stream.OpenByteArrayOutputStream;

public class PngEncoder {
    static final boolean DEBUG = false;
    HashMap testMap = new HashMap();
    CrcOutputStream out = new CrcOutputStream();
    OpenByteArrayOutputStream zipped = new OpenByteArrayOutputStream();
    Deflater deflater = new Deflater(7, false);
    private Rectangle requestedArea;
    double time = System.currentTimeMillis();

    public void time(String mark) {
        double d = System.currentTimeMillis();
        System.out.println(mark + ": " + (d - this.time));
        this.time = d;
    }

    public byte[] encode(int width, int height, byte[] rgb) {
        return this.encode(width, height, rgb, false);
    }

    public byte[] encode(int width, int height, byte[] rgb, boolean includeAlpha) {
        int xoffset = 0;
        int yoffset = 0;
        int targetWidth = width;
        int targetHeight = height;
        try {
            this.out.reset();
            this.out.write(137);
            this.out.write(80);
            this.out.write(78);
            this.out.write(71);
            this.out.write(13);
            this.out.write(10);
            this.out.write(26);
            this.out.write(10);
            this.out.writePngLen(13);
            this.out.resetCrc();
            this.out.writePngType(73, 72, 68, 82);
            this.out.writeInt(targetWidth);
            this.out.writeInt(targetHeight);
            this.out.write(8);
            if (!includeAlpha) {
                this.out.write(2);
            } else {
                this.out.write(6);
            }
            this.out.write(0);
            this.out.write(0);
            this.out.write(0);
            this.out.writePngCrc();
            this.zipped.reset();
            this.deflater.reset();
            DeflaterOutputStream dout = new DeflaterOutputStream((OutputStream)this.zipped, this.deflater);
            if (!includeAlpha) {
                int width3 = width * 3;
                int targetWidth3 = targetWidth * 3;
                for (int h = yoffset; h < yoffset + targetHeight; ++h) {
                    dout.write(0);
                    dout.write(rgb, h * width3 + xoffset * 3, targetWidth3);
                }
            } else {
                int width4 = width * 4;
                int targetWidth4 = targetWidth * 4;
                for (int h = yoffset; h < yoffset + targetHeight; ++h) {
                    dout.write(0);
                    dout.write(rgb, h * width4 + xoffset * 4, targetWidth4);
                }
            }
            dout.finish();
            dout.close();
            int zsize = this.zipped.size();
            this.out.writePngLen(zsize);
            this.out.resetCrc();
            this.out.writePngType(73, 68, 65, 84);
            this.out.write(this.zipped.getByteArray(), 0, zsize);
            this.out.writePngCrc();
            this.out.writePngLen(0);
            this.out.resetCrc();
            this.out.writePngType(73, 69, 78, 68);
            this.out.writePngCrc();
            return this.out.toByteArray();
        }
        catch (IOException xx) {
            xx.printStackTrace();
            return null;
        }
    }

    private static byte modSlow(int bits, byte dat) {
        int tmp = 0xFF & dat;
        tmp -= tmp % bits;
        dat = (byte)(0xFF & tmp);
        return dat;
    }

    public static void main(String[] args) throws Exception {
        int i;
        int MODBITS = 16;
        Robot r = new Robot();
        BufferedImage bimg = r.createScreenCapture(new Rectangle(0, 0, 128, 128));
        int blocks = 187;
        System.out.println(blocks + " blocks in a decent sized monitor (1920x1600)");
        PngEncoder enc = new PngEncoder();
        int[] ints = new int[10000];
        bimg.getRGB(0, 0, 100, 100, ints, 0, 100);
        byte[] rgbs = new byte[3 * ints.length];
        int index = 0;
        for (i = 0; i < ints.length; ++i) {
            rgbs[index++] = (byte)(ints[i] >>> 16);
            rgbs[index++] = (byte)(ints[i] >>> 8);
            rgbs[index++] = (byte)ints[i];
        }
        for (i = 0; i < rgbs.length; ++i) {
            rgbs[i] = PngEncoder.modSlow(32, rgbs[i]);
        }
        byte[] data = null;
        int N = 0;
        long t = System.currentTimeMillis() + 5000L;
        while (System.currentTimeMillis() < t) {
            for (int i2 = 0; i2 < 10; ++i2) {
                data = enc.encode(100, 100, rgbs);
                ++N;
            }
        }
        System.out.println(N + " per second, final size went from " + rgbs.length + " to " + data.length + " vs GZIP " + GZIPer.compress(rgbs, 1.0).length);
        data = enc.encode(100, 100, rgbs);
        FileOutputStream fout = new FileOutputStream("test.png");
        fout.write(data);
        fout.close();
        ImageIO.write((RenderedImage)bimg, "PNG", new File("test_imageio.png"));
        FileInputStream finA = new FileInputStream("test.png");
        FileInputStream finJ = new FileInputStream("test_imageio.png");
        System.out.println("Comparing...");
        boolean fail = false;
        int X = 10;
        int N2 = 0;
        while (true) {
            int A2 = finA.read();
            int J = finJ.read();
            String info = (String)enc.testMap.get(new Integer(N2));
            if (info != null) {
                System.out.println(" --- " + info + " --- ");
            }
            System.out.print("SH = " + A2);
            if (A2 < 10) {
                System.out.print(" ");
            }
            if (A2 < 100) {
                System.out.print(" ");
            }
            System.out.println("  JAVA = " + J);
            if (A2 != J) {
                System.out.println("DIFFERENCE AT INDEX " + N2);
                fail = true;
            }
            if (fail && --X == 0 || A2 == -1 && J == -1) break;
            ++N2;
        }
    }

    class CrcOutputStream
    extends OutputStream {
        OpenByteArrayOutputStream bout = new OpenByteArrayOutputStream();
        CRC32 crc = new CRC32();

        CrcOutputStream() {
        }

        public void resetCrc() {
            this.crc.reset();
        }

        @Override
        public void write(int b) throws IOException {
            this.bout.write(b);
            this.crc.update(b);
        }

        public byte[] getByteArray() {
            return this.bout.getByteArray();
        }

        public byte[] toByteArray() {
            return this.bout.toByteArray();
        }

        public void reset() {
            this.bout.reset();
            this.crc.reset();
        }

        public void writePngLen(int len) throws IOException {
            this.writeInt(len);
        }

        public void writePngCrc() throws IOException {
            this.writeInt((int)this.crc.getValue());
        }

        public void writePngType(int a, int b, int c, int d) throws IOException {
            this.write(a);
            this.write(b);
            this.write(c);
            this.write(d);
        }

        public void writeInt(int n) throws IOException {
            this.write((byte)(n >>> 24));
            this.write((byte)(n >>> 16));
            this.write((byte)(n >>> 8));
            this.write((byte)n);
        }

        public void stickTestMarker(String marker) {
        }
    }
}

