/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.cui.validators;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import utils.swing.cui.validators.Validator;
import utils.swing.layout.GbPanel;

public class RadioButtonsValidator
extends Validator {
    private int[] setOfValidIndices = null;

    public RadioButtonsValidator(int[] setOfValidIndices) {
        this.setOfValidIndices = setOfValidIndices;
    }

    public String getValidatorID() {
        return "radiobuttons";
    }

    public String toXML() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<Validator type=\"" + this.getValidatorID() + "\">");
        if (this.setOfValidIndices != null) {
            for (int i = 0; i < this.setOfValidIndices.length; ++i) {
                if (i > 0) {
                    buffer.append(",");
                }
                buffer.append(Integer.toString(this.setOfValidIndices[i]));
            }
        }
        buffer.append("</Validator>");
        return buffer.toString();
    }

    private boolean isValidIndex(int index) {
        for (int i = 0; i < this.setOfValidIndices.length; ++i) {
            if (this.setOfValidIndices[i] != index) continue;
            return true;
        }
        return false;
    }

    public boolean isValid(JComponent component) {
        if (!(component instanceof GbPanel)) {
            System.out.println("[RadioButtonsValidator] Unknown component type: " + component.getClass().getName());
            return false;
        }
        GbPanel panel = (GbPanel)component;
        int childComponents = panel.getComponentCount();
        for (int i = 0; i < childComponents; ++i) {
            JRadioButton button;
            Component comp = panel.getComponent(i);
            if (!(comp instanceof JRadioButton) || !(button = (JRadioButton)comp).isSelected() || !this.isValidIndex(i)) continue;
            return true;
        }
        return false;
    }
}

