/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.cui.ui;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import utils.swing.SwingStyleInterface;
import utils.swing.SwingUtil;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.cui.types.fields.ComboBoxField;
import utils.swing.cui.types.fields.TextField;
import utils.swing.cui.ui.ConfigUI;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class TextFieldConfigUI
extends ConfigUI
implements ActionListener {
    private JLabel defaultValueLabel;
    private JLabel exampleValueLabel;
    private JTextField valueField;
    private JTextField exampleField;
    private JCheckBox minCharBox;
    private JTextField minCharField;
    private JCheckBox maxCharBox;
    private JTextField maxCharField;
    private JLabel minLabel;
    private JLabel maxLabel;
    private JLabel minCharacters;
    private JLabel maxCharacters;
    private JComboBox validationBox;
    private JCheckBox requiredBox;

    public TextFieldConfigUI(ResourceBundle bundle, SwingStyleInterface style, AbstractField.ChangeListener listener) {
        super(bundle, style, listener);
    }

    private void updateEnabled() {
        boolean enabled = this.minCharBox.isSelected();
        this.minLabel.setEnabled(enabled);
        this.minCharacters.setEnabled(enabled);
        this.minCharField.setEnabled(enabled);
        enabled = this.maxCharBox.isSelected();
        this.maxLabel.setEnabled(enabled);
        this.maxCharacters.setEnabled(enabled);
        this.maxCharField.setEnabled(enabled);
    }

    @Override
    public void initUI() {
        this.requiredBox = new JCheckBox(this.bundle.getString("CUI_VALIDATION_REQUIRED"));
        this.requiredBox.addActionListener(this.actionChangeListener);
        this.valueField = new JTextField();
        this.valueField.addKeyListener(this.keyChangeListener);
        this.exampleField = new JTextField();
        this.exampleField.addKeyListener(this.keyChangeListener);
        String[] validationOptions = new String[]{this.bundle.getString("CUI_VALIDATION_ANY"), "SEPARATOR", this.bundle.getString("CUI_VALIDATION_NUMBER"), this.bundle.getString("CUI_VALIDATION_CHARACTERS"), this.bundle.getString("CUI_VALIDATION_ALPHANUMERIC"), "SEPARATOR", this.bundle.getString("CUI_VALIDATION_EMAIL"), this.bundle.getString("CUI_VALIDATION_WEBADDRESS"), "SEPARATOR", this.bundle.getString("CUI_VALIDATION_PASSWORD")};
        JLabel validationLabel = new JLabel(this.bundle.getString("CUI_VALIDATION_TEXT"));
        ComboBoxField comboBoxType = new ComboBoxField("", null, validationOptions);
        this.validationBox = (JComboBox)comboBoxType.getComponent();
        this.defaultValueLabel = new JLabel(this.bundle.getString("CUI_TEXT_DEFAULT"));
        this.exampleValueLabel = new JLabel(this.bundle.getString("CUI_TEXT_EXAMPLE"));
        this.maxCharBox = new JCheckBox();
        this.minCharBox = new JCheckBox();
        this.minCharField = new JTextField();
        this.maxCharField = new JTextField();
        this.minLabel = new JLabel(this.bundle.getString("CUI_TEXT_MIN"));
        this.maxLabel = new JLabel(this.bundle.getString("CUI_TEXT_MAX"));
        this.minCharacters = new JLabel(this.bundle.getString("CUI_TEXT_CHARACTERS") + ".");
        this.maxCharacters = new JLabel(this.bundle.getString("CUI_TEXT_CHARACTERS") + ".");
        this.validationBox.addActionListener(this.actionChangeListener);
        this.minCharBox.addActionListener(this.actionChangeListener);
        this.maxCharBox.addActionListener(this.actionChangeListener);
        this.minCharField.addKeyListener(this.keyChangeListener);
        this.maxCharField.addKeyListener(this.keyChangeListener);
        SwingUtil.setWidth((JComponent)this.valueField, (int)SimpleHelpLookAndFeel.scale((int)150));
        SwingUtil.setWidth((JComponent)this.exampleField, (int)SimpleHelpLookAndFeel.scale((int)150));
        SwingUtil.setWidth((JComponent)this.validationBox, (int)SimpleHelpLookAndFeel.scale((int)150));
        SwingUtil.setWidth((JComponent)this.maxCharField, (int)SimpleHelpLookAndFeel.scale((int)30));
        SwingUtil.setWidth((JComponent)this.minCharField, (int)SimpleHelpLookAndFeel.scale((int)30));
        this.minCharBox.addActionListener(this);
        this.maxCharBox.addActionListener(this);
        int Y = 0;
        int X = 0;
        this.rootComponent.add((Component)validationLabel, 0, 0, 1, 1, 0, 1, 13, 0);
        this.rootComponent.add((Component)this.validationBox, 1, 0, 1, 1, 0, 1, 17, 0);
        this.rootComponent.add((Component)this.requiredBox, 2, 0, 2, 1, 0, 1, 17, 0, (Insets)new ScaledInsets(3, 30, 3, 3));
        X = 0;
        this.rootComponent.add((Component)this.defaultValueLabel, X++, ++Y, 1, 1, 0, 1, 13, 0);
        this.rootComponent.add((Component)this.valueField, X++, Y, 1, 1, 0, 1, 17, 0);
        this.rootComponent.add((Component)this.minCharBox, X++, Y, 1, 1, 0, 1, 17, 0, (Insets)new ScaledInsets(3, 30, 3, 3));
        this.rootComponent.add((Component)this.minLabel, X++, Y, 1, 1, 0, 1, 17, 0, (Insets)new ScaledInsets(3, 0, 3, 3));
        this.rootComponent.add((Component)this.minCharField, X++, Y, 1, 1, 0, 1, 17, 0);
        this.rootComponent.add((Component)this.minCharacters, X++, Y, 1, 1, 100, 1, 17, 0);
        X = 0;
        this.rootComponent.add((Component)this.exampleValueLabel, X++, ++Y, 1, 1, 0, 1, 13, 0);
        this.rootComponent.add((Component)this.exampleField, X++, Y, 1, 1, 0, 1, 17, 0);
        this.rootComponent.add((Component)this.maxCharBox, X++, Y, 1, 1, 0, 1, 17, 0, (Insets)new ScaledInsets(3, 30, 3, 3));
        this.rootComponent.add((Component)this.maxLabel, X++, Y, 1, 1, 0, 1, 17, 0, (Insets)new ScaledInsets(3, 0, 3, 3));
        this.rootComponent.add((Component)this.maxCharField, X++, Y, 1, 1, 0, 1, 17, 0);
        this.rootComponent.add((Component)this.maxCharacters, X++, Y, 1, 1, 100, 1, 17, 0);
        this.updateEnabled();
    }

    @Override
    public void loadConfigurationFrom(CUIField uiType) {
        TextField textType = (TextField)uiType;
        String defaultValue = textType.getDefaultValue();
        String exampleValue = textType.getExampleValue();
        boolean required = textType.isRequired();
        if (defaultValue == null) {
            defaultValue = "";
        }
        if (exampleValue == null) {
            exampleValue = "";
        }
        this.valueField.setText(defaultValue);
        this.exampleField.setText(exampleValue);
        this.requiredBox.setSelected(required);
        switch (textType.getSubType()) {
            case 0: {
                this.validationBox.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.validationBox.setSelectedIndex(2);
                break;
            }
            case 3: {
                this.validationBox.setSelectedIndex(3);
                break;
            }
            case 4: {
                this.validationBox.setSelectedIndex(4);
                break;
            }
            case 5: {
                this.validationBox.setSelectedIndex(6);
                break;
            }
            case 6: {
                this.validationBox.setSelectedIndex(7);
                break;
            }
            case 7: {
                this.validationBox.setSelectedIndex(9);
            }
        }
        if (textType.getMin() != -1) {
            this.minCharBox.setSelected(true);
            this.minCharField.setText("" + textType.getMin());
        } else {
            this.minCharBox.setSelected(false);
        }
        if (textType.getMax() != -1) {
            this.maxCharBox.setSelected(true);
            this.maxCharField.setText("" + textType.getMax());
        } else {
            this.maxCharBox.setSelected(false);
        }
        this.updateEnabled();
    }

    @Override
    public void saveConfigurationTo(CUIField type) {
        TextField textType = (TextField)type;
        textType.clearValidators();
        if (this.valueField.getText().length() > 0) {
            textType.setDefaultValue(this.valueField.getText());
        }
        if (this.exampleField.getText().length() > 0) {
            textType.setExampleValue(this.exampleField.getText());
        }
        int min = -1;
        if (this.minCharBox.isSelected()) {
            min = Integer.parseInt(this.minCharField.getText());
        }
        int max = -1;
        if (this.maxCharBox.isSelected()) {
            max = Integer.parseInt(this.maxCharField.getText());
        }
        if (max != -1 || min != -1) {
            textType.setLengthConstraints(max, min);
        }
        if (this.requiredBox.isSelected()) {
            textType.setRequired(this.requiredBox.isSelected());
        }
        switch (this.validationBox.getSelectedIndex()) {
            case 0: {
                textType.setSubType(0);
                break;
            }
            case 2: {
                textType.setSubType(1);
                break;
            }
            case 3: {
                textType.setSubType(3);
                break;
            }
            case 4: {
                textType.setSubType(4);
                break;
            }
            case 6: {
                textType.setSubType(5);
                break;
            }
            case 7: {
                textType.setSubType(6);
                break;
            }
            case 9: {
                textType.setSubType(7);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.maxCharBox || e.getSource() == this.minCharBox) {
            this.updateEnabled();
        }
    }
}

