/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.virtualtree;

import javax.swing.JFrame;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import utils.swing.components.SHJTree;
import utils.swing.components.virtualtree.VirtualTreeInterface;
import utils.swing.components.virtualtree.VirtualTreeModel;
import utils.swing.components.virtualtree.VirtualTreeNode;
import utils.swing.customlaf.SHStyle;

public class VirtualTree {
    private SHJTree rootTree;
    private ExpansionListener expansionListener = new ExpansionListener();
    private VirtualTreeModel model;

    public JTree getRootComponent() {
        return this.rootTree;
    }

    public VirtualTree(VirtualTreeInterface treeInterface, VirtualTreeNode[] rootChildren) {
        this.rootTree = new SHJTree(SHStyle.SELECTION_BACKGROUND){

            @Override
            public boolean hasBeenExpanded(TreePath path) {
                return true;
            }
        };
        this.rootTree.addTreeWillExpandListener(this.expansionListener);
        this.model = new VirtualTreeModel(treeInterface);
        VirtualTreeNode root = (VirtualTreeNode)this.model.getRoot();
        root.removeAllChildren();
        for (int i = 0; i < rootChildren.length; ++i) {
            root.add(rootChildren[i]);
        }
        this.rootTree.setModel(this.model);
    }

    public void connected() {
        VirtualTreeNode root = (VirtualTreeNode)this.model.getRoot();
        this.model.updateGrandChildrenOf(new TreePath(new Object[]{root}));
    }

    public VirtualTreeModel getModel() {
        return this.model;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(500, 500);
        VirtualTreeInterface treeInterface = new VirtualTreeInterface(){
            int count = 0;

            @Override
            public Object[] getChildrenOf(Object parent) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return new Object[0];
            }
        };
        VirtualTreeNode[] rootChildren = new VirtualTreeNode[]{new VirtualTreeNode("A"), new VirtualTreeNode("B"), new VirtualTreeNode("C"), new VirtualTreeNode("D")};
        VirtualTree vt = new VirtualTree(treeInterface, rootChildren);
        frame.getContentPane().add(vt.getRootComponent());
        frame.setVisible(true);
    }

    class ExpansionListener
    implements TreeWillExpandListener {
        ExpansionListener() {
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            VirtualTree.this.model.updateGrandChildrenOf(event.getPath());
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        }
    }
}

