/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.path.elements;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;

public class OSXVolumeUtil {
    private static String OSX_MAIN_VOLUME_NAME = null;

    public static synchronized String getOSXVolumeName() {
        File[] roots;
        if (OSX_MAIN_VOLUME_NAME != null) {
            return OSX_MAIN_VOLUME_NAME;
        }
        for (File f : roots = OSXVolumeUtil.getMacRoots()) {
            try {
                if (!f.getCanonicalPath().equals("/")) continue;
                OSX_MAIN_VOLUME_NAME = f.getName();
                return OSX_MAIN_VOLUME_NAME;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return null;
    }

    public static boolean isOSXRootDrive(File chosenFile) {
        if (chosenFile.toString().equals("/")) {
            return true;
        }
        try {
            if (chosenFile.getCanonicalPath().equals("/")) {
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static File[] getMacRoots() {
        File volumes = new File("/Volumes");
        return volumes.listFiles(new FileFilter(){

            @Override
            public boolean accept(File path) {
                if (path.isDirectory()) {
                    return !path.getName().equals("MobileBackups");
                }
                return false;
            }
        });
    }
}

