/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.path.elements;

import java.io.File;
import javax.swing.Icon;
import utils.swing.components.path.elements.PathElement;
import utils.swing.icons.SystemIconUtil;

public class FilePathElement
extends PathElement {
    private File file;
    private Icon icon;
    private String alias = null;

    public FilePathElement(File file, String alias, boolean isLocalFilesystem) {
        this.alias = alias;
        this.file = file;
        this.icon = isLocalFilesystem ? (file.exists() ? SystemIconUtil.getSystemIconFor((File)file) : SystemIconUtil.getDefaultFolderIcon()) : SystemIconUtil.getDefaultFolderIcon();
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public String getText() {
        if (this.alias == null) {
            return this.file.getName();
        }
        return this.alias;
    }

    public File getFile() {
        return this.file;
    }
}

