/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.path;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;

public class PathBarLayoutManager
implements LayoutManager {
    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension dim = new Dimension(0, 0);
        int minWidth = 0;
        for (Component c : parent.getComponents()) {
            dim.width += c.getPreferredSize().width;
            dim.height = Math.max(dim.height, c.getPreferredSize().height);
            minWidth += c.getMinimumSize().width;
        }
        if (dim.width < minWidth) {
            dim.width = minWidth;
        }
        return dim;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Dimension dim = new Dimension(0, 0);
        for (Component c : parent.getComponents()) {
            dim.width += c.getMinimumSize().width;
            dim.height = Math.max(dim.height, c.getMinimumSize().height);
        }
        return dim;
    }

    @Override
    public void layoutContainer(Container parent) {
        Dimension dim;
        Component c;
        int cIndex;
        int startComponent;
        int cMinWidth;
        int cPrefWidth;
        Component[] components = parent.getComponents();
        int newWidth = this.preferredLayoutSize((Container)parent).width;
        int rightPadding = Math.max(0, parent.getWidth() - newWidth);
        int height = parent.getHeight();
        for (startComponent = 0; startComponent < components.length && newWidth > parent.getWidth(); newWidth -= cPrefWidth - cMinWidth, ++startComponent) {
            cPrefWidth = components[startComponent].getPreferredSize().width;
            cMinWidth = components[startComponent].getMinimumSize().width;
        }
        if (startComponent > 0 && newWidth < parent.getWidth()) {
            --startComponent;
        }
        int x = 0;
        for (cIndex = 0; cIndex < startComponent; ++cIndex) {
            c = components[cIndex];
            dim = c.getMinimumSize();
            c.setBounds(x, 0, dim.width, height);
            x += dim.width;
        }
        x = parent.getWidth() - rightPadding;
        for (cIndex = components.length - 1; cIndex >= startComponent; --cIndex) {
            c = components[cIndex];
            dim = c.getPreferredSize();
            int width = dim.width;
            if ((x -= width) < 0) {
                width += x;
                x = 0;
            }
            c.setBounds(x, 0, width, height);
        }
    }
}

