/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.path;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import utils.files.FileUtil;
import utils.files.RemoteFile;
import utils.ostools.OS;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.components.JIconTextField;
import utils.swing.components.JSmartPopupMenu;
import utils.swing.components.path.PathBarLayoutManager;
import utils.swing.components.path.PathBarListener;
import utils.swing.components.path.PathElementUI;
import utils.swing.components.path.elements.DrivesPathElement;
import utils.swing.components.path.elements.FTPVolume;
import utils.swing.components.path.elements.FilePathElement;
import utils.swing.components.path.elements.OSXVolumeUtil;
import utils.swing.components.path.elements.PathElement;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.icons.SystemIconUtil;

public class PathBar
extends MouseAdapter
implements ComponentListener,
KeyListener,
ListSelectionListener,
FocusListener {
    private final boolean isLocalFilesystem;
    private JPanel rootComponent = new ColorPropagatingPanel((LayoutManager)new BorderLayout());
    private JLabel shortcuts = new JLabel("+");
    private JPanel pathBarRoot = new JPanel(new PathBarLayoutManager());
    private JPanel textEntryRoot = new JPanel(new BorderLayout());
    private JIconTextField pathField = new JIconTextField();
    private JPopupMenu pathPopup = new JPopupMenu();
    private JPanel recentPathPanel = new JPanel();
    private JList<String> historyJList = new JList();
    private PathElement[] elements;
    private ArrayList<PathBarListener> listeners = new ArrayList();
    private FTPVolume[] fsRoots = null;
    private FTPVolume[] shortcutFolders = null;
    private int remoteOS;
    private boolean showHiddenFiles = false;
    private JCheckBoxMenuItem hiddenFilesToggleItem = null;
    private PathElementUI highlighedPathElement = null;
    private LinkedList<String> historyList = new LinkedList();
    private boolean loadingModel;
    private boolean showHistory = true;

    public PathBar(boolean isLocalFilesystem) {
        this.isLocalFilesystem = isLocalFilesystem;
        SwingUtil.setHeight((JComponent)this.rootComponent, (int)SimpleHelpLookAndFeel.scale((int)24));
        this.rootComponent.addMouseListener(this);
        this.remoteOS = OS.base_type;
        this.initUI();
        this.fsRoots = PathBar.getLocalVolumes();
    }

    public void showHistory(boolean showHistory) {
        this.showHistory = showHistory;
    }

    public void setShortcutFoldersImage(Icon image) {
        this.shortcuts.setText("");
        this.shortcuts.setIcon(image);
    }

    public static FTPVolume[] getLocalVolumes() {
        ArrayList<FTPVolume> volumes = new ArrayList<FTPVolume>();
        if (OS.isMacOS()) {
            File[] macRoots;
            for (File macRoot : macRoots = OSXVolumeUtil.getMacRoots()) {
                volumes.add(new FTPVolume(macRoot.getName(), macRoot.getAbsolutePath(), OSXVolumeUtil.isOSXRootDrive(macRoot)));
            }
        } else {
            File[] tmp;
            for (File aTmp : tmp = File.listRoots()) {
                volumes.add(new FTPVolume(aTmp.getAbsolutePath()));
            }
        }
        return volumes.toArray(new FTPVolume[0]);
    }

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public void setFileSystemRoots(FTPVolume[] roots) {
        ArrayList<FTPVolume> rootList = new ArrayList<FTPVolume>();
        ArrayList<FTPVolume> specialList = new ArrayList<FTPVolume>();
        for (FTPVolume volume : roots) {
            if (volume.isShortcut) {
                specialList.add(volume);
                continue;
            }
            rootList.add(volume);
        }
        this.fsRoots = rootList.toArray(new FTPVolume[0]);
        this.shortcutFolders = specialList.toArray(new FTPVolume[0]);
        this.shortcuts.setVisible(this.hiddenFilesToggleItem != null || this.shortcutFolders.length > 0);
        this.shortcuts.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)2));
    }

    public void setShowHiddenFiles(boolean showToggleOption, String menuText, Icon on, Icon off) {
        if (showToggleOption) {
            this.hiddenFilesToggleItem = new JCheckBoxMenuItem();
            this.hiddenFilesToggleItem.setText(menuText);
        } else {
            this.hiddenFilesToggleItem = null;
        }
    }

    public void setCurrentFolder(File folder) {
        PathElement[] elements = this.getPathElementsToRoot(folder);
        this.setPathElements(elements);
    }

    public void addPathBarListener(PathBarListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.rootComponent.isEnabled()) {
            return;
        }
        if (e.getSource() instanceof PathElementUI) {
            PathElementUI ui = (PathElementUI)e.getSource();
            ArrayList<PathElement> newList = new ArrayList<PathElement>();
            for (PathElement element : this.elements) {
                newList.add(element);
                if (ui.getPathElement() == element) break;
            }
            this.setPathElements(newList.toArray(new PathElement[0]));
        } else if (e.getSource() == this.rootComponent || e.getSource() == this.pathBarRoot) {
            this.switchTextEntry();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (e.getSource() == this.rootComponent) {
            return;
        }
        if (!this.rootComponent.isEnabled()) {
            return;
        }
        PathElementUI ui = (PathElementUI)e.getSource();
        if (this.highlighedPathElement != null && ui == this.highlighedPathElement) {
            return;
        }
        if (this.highlighedPathElement != null) {
            this.highlighedPathElement.unhighlight();
        }
        this.highlighedPathElement = ui;
        ui.highlight();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.rootComponent.isEnabled()) {
            return;
        }
        if (e.getSource() == this.rootComponent) {
            if (this.highlighedPathElement != null) {
                this.highlighedPathElement.unhighlight();
            }
        } else {
            PathElementUI ui = (PathElementUI)e.getSource();
            if (this.highlighedPathElement == ui) {
                this.highlighedPathElement.unhighlight();
            }
            this.highlighedPathElement = null;
        }
    }

    private void notifySelect(PathElement elementSelected) {
        for (PathBarListener listener : this.listeners) {
            listener.selectedPathElement(this, elementSelected);
        }
    }

    private void initUI() {
        this.historyJList.setFixedCellHeight(SimpleHelpLookAndFeel.scale((int)20));
        this.historyJList.addListSelectionListener(this);
        this.recentPathPanel.setLayout(new GridLayout(1, 1));
        this.recentPathPanel.add(this.historyJList);
        JScrollPane pane = new JScrollPane(this.recentPathPanel);
        pane.setBorder(SHBorderFactory.createEmptyBorder());
        pane.setHorizontalScrollBarPolicy(31);
        this.pathPopup.setLayout(new GridLayout(1, 1));
        this.pathPopup.add(pane);
        this.textEntryRoot.add(this.pathField);
        this.pathField.setBorder(SHBorderFactory.createEmptyBorder((int)2, (int)2, (int)2, (int)2));
        this.pathField.addKeyListener(this);
        this.pathField.addFocusListener(this);
        this.pathBarRoot.setCursor(Cursor.getPredefinedCursor(2));
        this.pathField.addIcon(SystemIconUtil.getDefaultFolderIcon(), false, false, "pathbar");
        this.shortcuts.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                final JMenuItem[] items = new JMenuItem[PathBar.this.shortcutFolders.length];
                for (int i = 0; i < items.length; ++i) {
                    FTPVolume shortcut = PathBar.this.shortcutFolders[i];
                    JMenuItem[] item = new JMenuItem();
                    item.setText(shortcut.name);
                    if (PathBar.this.isLocalFilesystem) {
                        item.setIcon(SystemIconUtil.getSystemIconFor((File)new File(shortcut.path)));
                    } else {
                        item.setIcon(SystemIconUtil.getDefaultFolderIcon());
                    }
                    items[i] = item;
                }
                ActionListener listener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        for (int i = 0; i < items.length; ++i) {
                            if (items[i] != e.getSource()) continue;
                            PathBar.this.setCurrentFolder(new File(((PathBar)PathBar.this).shortcutFolders[i].path));
                            return;
                        }
                        if (e.getSource() == PathBar.this.hiddenFilesToggleItem) {
                            PathBar.this.showHiddenFiles = !PathBar.this.showHiddenFiles;
                            for (PathBarListener listener : PathBar.this.listeners) {
                                listener.setShowHiddenFiles(PathBar.this, PathBar.this.showHiddenFiles);
                            }
                        }
                    }
                };
                JSmartPopupMenu menu = new JSmartPopupMenu();
                for (JMenuItem item : items) {
                    item.addActionListener(listener);
                    menu.add(item);
                }
                if (PathBar.this.hiddenFilesToggleItem != null) {
                    ActionListener[] actionListeners;
                    if (items.length > 0) {
                        menu.addSeparator();
                    }
                    menu.add(PathBar.this.hiddenFilesToggleItem);
                    for (ActionListener listenerRemove : actionListeners = PathBar.this.hiddenFilesToggleItem.getActionListeners()) {
                        PathBar.this.hiddenFilesToggleItem.removeActionListener(listenerRemove);
                    }
                    PathBar.this.hiddenFilesToggleItem.addActionListener(listener);
                }
                menu.show(PathBar.this.shortcuts, 0, PathBar.this.shortcuts.getHeight() + 1);
            }
        });
        this.switchPathBar();
    }

    private void switchTextEntry() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PathBar.this.pathField.setText(PathBar.this.getCurrentFolder().getRemotePath());
                PathBar.this.rootComponent.removeAll();
                PathBar.this.rootComponent.add((Component)PathBar.this.textEntryRoot, "Center");
                PathBar.this.rootComponent.add((Component)PathBar.this.shortcuts, "East");
                PathBar.this.rootComponent.revalidate();
                PathBar.this.rootComponent.repaint();
                PathBar.this.pathField.requestFocusInWindow();
                if (PathBar.this.showHistory && PathBar.this.historyList.size() > 0) {
                    DefaultListModel<String> model = new DefaultListModel<String>();
                    boolean first = true;
                    for (String s : PathBar.this.historyList) {
                        if (first) {
                            first = false;
                            continue;
                        }
                        model.addElement(s);
                    }
                    while (PathBar.this.historyList.size() > 500) {
                        PathBar.this.historyList.removeLast();
                    }
                    PathBar.this.loadingModel = true;
                    try {
                        PathBar.this.historyJList.setModel(model);
                    }
                    finally {
                        PathBar.this.loadingModel = false;
                    }
                    Rectangle bounds = PathBar.this.pathBarRoot.getBounds();
                    Point location = PathBar.this.textEntryRoot.getLocationOnScreen();
                    location.y += bounds.height;
                    Dimension size = new Dimension(bounds.width, SimpleHelpLookAndFeel.scale((int)150));
                    PathBar.this.pathPopup.setPreferredSize(size);
                    PathBar.this.pathPopup.setSize(size);
                    PathBar.this.pathPopup.setLocation(location);
                    PathBar.this.pathPopup.setVisible(true);
                }
            }
        });
    }

    private void switchPathBar() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PathBar.this.pathPopup.setVisible(false);
                PathBar.this.rootComponent.removeAll();
                PathBar.this.rootComponent.add((Component)PathBar.this.pathBarRoot, "Center");
                PathBar.this.rootComponent.add((Component)PathBar.this.shortcuts, "East");
                PathBar.this.rootComponent.revalidate();
                PathBar.this.rootComponent.repaint();
            }
        });
    }

    public void setPathElements(PathElement[] elements) {
        String newPath;
        this.elements = elements;
        this.pathBarRoot.removeAll();
        PathElement last = null;
        for (PathElement element : elements) {
            PathElementUI uiElement = new PathElementUI(element);
            uiElement.setBackground(this.pathBarRoot.getBackground());
            uiElement.addMouseListener(this);
            this.pathBarRoot.add(uiElement);
            last = uiElement.getPathElement();
        }
        RemoteFile currentFolder = this.getCurrentFolder();
        if (currentFolder != null && (newPath = this.getCurrentFolder().getRemotePath()) != null) {
            Iterator iterator = this.historyList.iterator();
            while (iterator.hasNext()) {
                String next = (String)iterator.next();
                if (!next.equals(newPath)) continue;
                iterator.remove();
            }
            this.historyList.addFirst(newPath);
        }
        this.pathBarRoot.revalidate();
        this.pathBarRoot.repaint();
        this.notifySelect(last);
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public void setEnabled(boolean enabled) {
        this.pathBarRoot.setEnabled(enabled);
        for (Component c : this.pathBarRoot.getComponents()) {
            c.setEnabled(enabled);
        }
    }

    public RemoteFile getCurrentFolder() {
        if (this.elements == null || this.elements.length == 0) {
            return new RemoteFile((File)null, this.remoteOS == 0);
        }
        PathElement lastElement = this.elements[this.elements.length - 1];
        if (lastElement instanceof FilePathElement) {
            File file = ((FilePathElement)lastElement).getFile();
            return new RemoteFile(file, this.remoteOS == 0);
        }
        return new RemoteFile((File)null, this.remoteOS == 0);
    }

    private PathElement[] getPathElementsToRoot(File file) {
        if (!OS.isWindows() && this.remoteOS == 0) {
            file = new File(file.getPath().replace("\\", "/"));
        }
        ArrayList<PathElement> elements = new ArrayList<PathElement>();
        this.getPathElementsToRoot(file, elements);
        return elements.toArray(new PathElement[0]);
    }

    private FTPVolume getOSXRootVolume() {
        for (FTPVolume volume : this.fsRoots) {
            if (!volume.isOSXRoot) continue;
            return volume;
        }
        return null;
    }

    private boolean getPathElementsToRoot(File file, ArrayList<PathElement> elements) {
        if (file == null) {
            elements.add(new DrivesPathElement(this.fsRoots));
            return true;
        }
        File parentFile = file.getParentFile();
        boolean amRoot = this.getPathElementsToRoot(parentFile, elements);
        String alias = null;
        if (amRoot && this.remoteOS == 1) {
            FTPVolume volume = this.getOSXRootVolume();
            alias = volume != null ? volume.name : "/";
        } else if (this.remoteOS == 2 && amRoot) {
            if (file.getPath().equals("/")) {
                alias = "/";
            }
        } else if (this.remoteOS == 0 && amRoot) {
            if (!file.getPath().endsWith("\\")) {
                file = new File(file.getPath() + "\\");
            }
            alias = !file.getPath().equals("\\\\") ? FileUtil.trimTrailingSlash((String)file.getPath()) : "\\\\";
        }
        long T = System.currentTimeMillis();
        elements.add(new FilePathElement(file, alias, this.isLocalFilesystem));
        T = System.currentTimeMillis() - T;
        if (T > 1000L) {
            System.out.println("*****WARNING Create new file path element took a long time " + T + " - " + file + " / " + alias);
        }
        return false;
    }

    public FTPVolume[] getVolumes() {
        return this.fsRoots;
    }

    public void setBackground(Color color) {
        this.rootComponent.setBackground(color);
        this.pathBarRoot.setBackground(color);
        for (Component c : this.pathBarRoot.getComponents()) {
            c.setBackground(color);
        }
    }

    public boolean isVolumeListSelected() {
        return this.elements == null || this.elements.length <= 1;
    }

    public void setOS(int remoteOsBase) {
        this.remoteOS = remoteOsBase;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            String text = this.pathField.getText();
            this.setPathByText(text);
        } else if (e.getKeyCode() == 27) {
            this.switchPathBar();
        }
    }

    private void setPathByText(String text) {
        String result;
        if (text == null) {
            this.switchPathBar();
            return;
        }
        String proc = text.trim();
        if (proc.startsWith("%") && proc.endsWith("%")) {
            proc = proc.substring(1, proc.length() - 1);
            for (PathBarListener listener : this.listeners) {
                result = listener.resolveEnvironmental(proc, this);
                if (result == null) continue;
                text = result;
                break;
            }
        }
        if (proc.startsWith("$")) {
            proc = proc.substring(1);
            for (PathBarListener listener : this.listeners) {
                result = listener.resolveEnvironmental(proc, this);
                if (result == null) continue;
                text = result;
                break;
            }
        }
        File newPath = new File(text);
        if (this.isLocalFilesystem) {
            newPath = newPath.getAbsoluteFile();
        }
        this.setCurrentFolder(newPath);
        this.switchPathBar();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.loadingModel) {
            return;
        }
        if (e.getValueIsAdjusting()) {
            return;
        }
        String newPath = this.historyJList.getSelectedValue();
        this.setPathByText(newPath);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.switchPathBar();
    }
}

