/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.listui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.layout.GbPanel;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jlist.SimpleListModel;

public abstract class AbstractListUI<T>
extends ColorPropagatingPanel
implements ActionListener,
ListSelectionListener {
    protected ResourceBundle lang;
    protected JButton addButton;
    protected JButton deleteButton;
    protected JButton upButton;
    protected JButton downButton;
    protected JList elementList;
    protected JScrollPane scrollPane;
    protected SimpleList<T> list = new SimpleList();
    protected SimpleListModel<T> listModel = new SimpleListModel<T>(this.list);
    private final Object LOCK = new Object();
    protected boolean reorderable = false;
    protected boolean small = false;
    GbPanel buttonsPanel = new GbPanel();
    private ArrayList<ListChangeListner> listeners = new ArrayList();

    public AbstractListUI(ResourceBundle lang, T[] initialList, boolean reorder, boolean small) {
        this(lang, reorder, small);
        if (initialList != null) {
            this.setObjects(initialList);
        }
    }

    protected abstract Icon getAddIcon();

    protected abstract Icon getDeleteIcon();

    protected abstract Icon getUpIcon();

    protected abstract Icon getDownIcon();

    protected boolean isHorizontal() {
        return true;
    }

    public AbstractListUI(ResourceBundle lang, boolean reorder, boolean small) {
        this.lang = lang;
        this.reorderable = reorder;
        this.small = small;
        this.addButton = new JButton(this.getAddIcon());
        this.deleteButton = new JButton(this.getDeleteIcon());
        this.upButton = new JButton(this.getUpIcon());
        this.downButton = new JButton(this.getDownIcon());
        SwingUtil.setSize((JComponent)this.addButton, (int)SimpleHelpLookAndFeel.scale((int)26), (int)SimpleHelpLookAndFeel.scale((int)24));
        SwingUtil.setSize((JComponent)this.deleteButton, (int)SimpleHelpLookAndFeel.scale((int)26), (int)SimpleHelpLookAndFeel.scale((int)24));
        SwingUtil.setSize((JComponent)this.upButton, (int)SimpleHelpLookAndFeel.scale((int)26), (int)SimpleHelpLookAndFeel.scale((int)24));
        SwingUtil.setSize((JComponent)this.downButton, (int)SimpleHelpLookAndFeel.scale((int)26), (int)SimpleHelpLookAndFeel.scale((int)24));
        this.addButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.upButton.addActionListener(this);
        this.downButton.addActionListener(this);
        this.deleteButton.setEnabled(false);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        this.elementList = new JList();
        this.elementList.getSelectionModel().addListSelectionListener(this);
        this.elementList.setCellRenderer(this.getCellRenderer());
        this.elementList.setModel(this.listModel);
        this.scrollPane = new JScrollPane(this.elementList);
        this.initUI();
    }

    public void setScrollPaneBorder(Border border) {
        this.scrollPane.setBorder(border);
    }

    public void setElementListBorder(Border border) {
        this.elementList.setBorder(border);
    }

    protected ListCellRenderer getCellRenderer() {
        return new IconListRenderer();
    }

    public JList getList() {
        return this.elementList;
    }

    public SimpleList<T> getSimpleList() {
        return this.list;
    }

    public void setEnabled(boolean bool) {
        super.setEnabled(bool);
        this.updateEnabled(bool);
    }

    private void updateEnabled(boolean bool) {
        this.elementList.setEnabled(bool);
        this.addButton.setEnabled(bool);
        int selectedIndex = this.elementList.getSelectedIndex();
        if (bool && selectedIndex != -1) {
            this.deleteButton.setEnabled(bool);
            if (this.listModel.getSize() <= 1) {
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            } else if (selectedIndex == 0) {
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(bool);
            } else if (selectedIndex + 1 == this.listModel.getSize()) {
                this.upButton.setEnabled(bool);
                this.downButton.setEnabled(false);
            }
        } else {
            this.deleteButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObjects(T[] objects) {
        Object object = this.LOCK;
        synchronized (object) {
            if (objects != null && objects.length > 0) {
                if (!this.reorderable && objects[0] instanceof Comparable) {
                    try {
                        Arrays.sort(objects);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                try {
                    this.list.startBatch();
                    while (this.list.size() > objects.length) {
                        this.list.remove(this.list.size() - 1);
                    }
                    for (int i = 0; i < objects.length; ++i) {
                        if (i < this.list.size()) {
                            this.list.set(i, objects[i]);
                            continue;
                        }
                        this.list.add(objects[i]);
                    }
                }
                finally {
                    this.list.endBatch();
                }
            }
        }
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.elementList.addListSelectionListener(listener);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.buttonsPanel != null) {
            this.buttonsPanel.setBackground(color);
        }
    }

    private void initUI() {
        if (this.isHorizontal()) {
            this.setLayout(new BorderLayout(5, 5));
            this.add(this.scrollPane, "Center");
            SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup((boolean)true, (AbstractButton[])new JButton[]{this.addButton, this.deleteButton});
            int Y = 0;
            this.buttonsPanel.add((Component)this.addButton, 0, Y++, 1, 1, 0, 0, 10, 0);
            this.buttonsPanel.add((Component)this.deleteButton, 0, Y++, 1, 1, 0, 0, 10, 0);
            if (this.reorderable) {
                this.buttonsPanel.add((Component)this.upButton, 0, Y++, 1, 1, 0, 0, 10, 0);
                this.buttonsPanel.add((Component)this.downButton, 0, Y++, 1, 1, 0, 0, 10, 0);
                SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup((boolean)true, (AbstractButton[])new JButton[]{this.addButton, this.deleteButton, this.upButton, this.downButton});
            } else {
                SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup((boolean)true, (AbstractButton[])new JButton[]{this.addButton, this.deleteButton});
            }
            JPanel jp = new JPanel();
            SwingUtil.setSize((JComponent)jp, (int)0, (int)4);
            this.buttonsPanel.add((Component)jp, 0, Y++, 1, 1, 0, 100, 10, 3);
            this.add((Component)this.buttonsPanel, "East");
        } else {
            this.setLayout(new BorderLayout(5, 5));
            this.add(this.scrollPane, "Center");
            SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup((boolean)false, (AbstractButton[])new JButton[]{this.addButton, this.deleteButton});
            int X = 0;
            this.buttonsPanel.add((Component)this.addButton, X++, 0, 1, 1, 0, 0, 10, 0);
            this.buttonsPanel.add((Component)this.deleteButton, X++, 0, 1, 1, 0, 0, 10, 0);
            if (this.reorderable) {
                this.buttonsPanel.add((Component)this.upButton, X++, 0, 1, 1, 0, 0, 10, 0);
                this.buttonsPanel.add((Component)this.downButton, X++, 0, 1, 1, 0, 0, 10, 0);
                SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup((boolean)false, (AbstractButton[])new JButton[]{this.addButton, this.deleteButton, this.upButton, this.downButton});
            } else {
                SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup((boolean)false, (AbstractButton[])new JButton[]{this.addButton, this.deleteButton});
            }
            this.add((Component)this.buttonsPanel, "South");
        }
    }

    protected boolean confirmDelete(T selected) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        boolean doSave = true;
        if (e.getSource().equals(this.addButton)) {
            T newObject = this.getNewObject();
            if (newObject == null) {
                return;
            }
            this.list.add(newObject);
            this.elementList.setSelectedValue(newObject, true);
            this.elementAdded(newObject);
        } else if (e.getSource().equals(this.deleteButton)) {
            T selected;
            int index = this.elementList.getSelectedIndex();
            if (index > -1 && (selected = this.list.get(index)) != null && this.confirmDelete(selected)) {
                Object object = this.LOCK;
                synchronized (object) {
                    this.list.remove(selected);
                }
                if (!this.elementRemoved(selected)) {
                    doSave = false;
                }
            }
        } else {
            if (e.getSource().equals(this.upButton)) {
                Object object = this.LOCK;
                synchronized (object) {
                    int index = this.elementList.getSelectedIndex();
                    int prev = index--;
                    if (prev >= 0) {
                        T indexObject = this.list.get(index);
                        T prevObject = this.list.get(prev);
                        this.list.set(index, prevObject);
                        this.list.set(prev, indexObject);
                        this.elementList.setSelectedIndex(index);
                    }
                }
            }
            if (e.getSource().equals(this.downButton)) {
                Object object = this.LOCK;
                synchronized (object) {
                    int index = this.elementList.getSelectedIndex();
                    int next = index++;
                    if (next < this.list.size()) {
                        T indexObject = this.list.get(index);
                        T nextObject = this.list.get(next);
                        this.list.set(index, nextObject);
                        this.list.set(next, indexObject);
                        this.elementList.setSelectedIndex(index);
                    }
                }
            }
        }
        if (doSave) {
            this.listChanged();
        }
        this.notifyListChangeListeners();
    }

    public void setRowHeight(int rowHeight) {
        this.elementList.setFixedCellHeight(rowHeight);
    }

    public void setSelectedElement(T element) {
        int index = this.list.indexOf(element);
        this.elementList.setSelectedIndex(index);
    }

    public void addListChangeListener(ListChangeListner listener) {
        this.listeners.add(listener);
    }

    private void notifyListChangeListeners() {
        for (ListChangeListner change : this.listeners) {
            change.listChanged(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T[] getObjects(T[] array) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.list.toArray((X[])array);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateEnabled(this.isEnabled());
    }

    protected abstract T getNewObject();

    protected abstract Icon getIconForObject(T var1);

    protected abstract void listChanged();

    protected boolean elementRemoved(T selected) {
        return true;
    }

    protected void elementAdded(T newObject) {
    }

    class IconListRenderer
    extends DefaultListCellRenderer {
        IconListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Icon icon = AbstractListUI.this.getIconForObject(value);
            label.setIcon(icon);
            return label;
        }
    }

    public static interface ListChangeListner {
        public void listChanged(AbstractListUI var1);
    }
}

