/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.animated.slider;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import utils.swing.SwingUtil;
import utils.swing.components.animated.slider.ChoiceItem;
import utils.swing.components.animated.slider.ComponentSliderPanel;
import utils.swing.components.animated.slider.SlidingChoiceListener;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.layout.GbPanel;

public class SlidingChoiceList
implements MouseListener,
ActionListener {
    private static final boolean ANIMATE = false;
    private ComponentSliderPanel rootComponent = new ComponentSliderPanel(300L);
    private JScrollPane startContentPanel;
    private ChoiceItemPanel currentItemPanel;
    private JPanel subContentPanel;
    private JButton backToMainMenuButton;
    private JButton backToSubMenuButton;
    private SlidingChoiceListener listener;
    static final Border choiceItemBorderTitle = SHBorderFactory.createEmptyBorder((int)10, (int)10, (int)0, (int)10);
    static final Border choiceItemBorderDesc = SHBorderFactory.createEmptyBorder((int)5, (int)10, (int)0, (int)10);
    static final Border choiceItemBorderExample = SHBorderFactory.createEmptyBorder((int)2, (int)10, (int)0, (int)10);

    public void setSlidingChoiceListener(SlidingChoiceListener listener) {
        this.listener = listener;
    }

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    private GbPanel getContentPanelFor(ChoiceItem[] items) {
        GbPanel contentPanel = new GbPanel();
        for (int i = 0; i < items.length; ++i) {
            ChoiceItemPanel choiceItemPanel = new ChoiceItemPanel(items[i], false);
            choiceItemPanel.addMouseListener(this);
            for (Component c : choiceItemPanel.getComponents()) {
                c.addMouseListener(this);
            }
            contentPanel.add((Component)((Object)choiceItemPanel), 0, i, 1, 1, 1, 0, 10, 2);
        }
        contentPanel.add((Component)new JPanel(), 0, items.length, 1, 1, 1, 1, 10, 2);
        return contentPanel;
    }

    public SlidingChoiceList(ArrayList<ChoiceItem> items) {
        ChoiceItem[] itema = new ChoiceItem[items.size()];
        items.toArray(itema);
        this.init(itema);
    }

    public SlidingChoiceList(ChoiceItem[] items) {
        this.init(items);
    }

    public void initBackButton(JButton back) {
        back.setText("Back");
    }

    private void init(ChoiceItem[] items) {
        this.backToMainMenuButton = new JButton();
        this.initBackButton(this.backToMainMenuButton);
        this.backToMainMenuButton.addActionListener(this);
        this.backToSubMenuButton = new JButton();
        this.initBackButton(this.backToSubMenuButton);
        this.backToSubMenuButton.addActionListener(this);
        GbPanel contentPanelForItems = this.getContentPanelFor(items);
        this.startContentPanel = new JScrollPane((Component)contentPanelForItems);
        this.startContentPanel.setBorder(SHBorderFactory.createMatteBorder((int)0, (int)0, (int)1, (int)0, (Color)SHStyle.BORDER_COLOR));
        this.rootComponent.setContentComponent(this.startContentPanel);
        ChoiceItem preSelectedItem = this.getPreselectedItem(items);
        if (preSelectedItem != null) {
            ChoiceItem[] path;
            for (ChoiceItem item : path = preSelectedItem.getPathToRoot()) {
                ChoiceItemPanel panel = this.getShowingPanelForItem(this.rootComponent, item);
                if (panel != null) {
                    if (panel.item.hasSubChoices()) {
                        this.transitionWithChildren(panel, false);
                        continue;
                    }
                    this.transition(panel, false);
                    continue;
                }
                System.out.println("[SlidingChoiceList] ERROR: asked to show a panel that doesn't exist?");
            }
        }
    }

    private ChoiceItemPanel getShowingPanelForItem(JComponent contentPanelForItems, ChoiceItem item) {
        for (Component c : contentPanelForItems.getComponents()) {
            ChoiceItemPanel result;
            ChoiceItemPanel cip;
            if (c instanceof ChoiceItemPanel && (cip = (ChoiceItemPanel)((Object)c)).item.equals(item)) {
                return cip;
            }
            if (!(c instanceof JComponent) || (result = this.getShowingPanelForItem((JComponent)c, item)) == null) continue;
            return result;
        }
        return null;
    }

    private ChoiceItem getPreselectedItem(ChoiceItem[] items) {
        for (ChoiceItem item : items) {
            ChoiceItem result;
            if (item.preSelected) {
                return item;
            }
            if (!item.hasSubChoices() || (result = this.getPreselectedItem(item.children)) == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Container c = (Container)e.getSource();
        while (!(c instanceof ChoiceItemPanel)) {
            c = c.getParent();
        }
        ChoiceItemPanel panel = (ChoiceItemPanel)((Object)c);
        if (panel.item.hasSubChoices()) {
            this.transitionWithChildren(panel, false);
        } else {
            this.transition(panel, false);
        }
    }

    private void transitionWithChildren(ChoiceItemPanel panel, boolean animate) {
        this.currentItemPanel = panel;
        JPanel targetContentPanel = new JPanel(new BorderLayout());
        Dimension headerSize = panel.getSize();
        GbPanel headerPanel = new GbPanel();
        headerPanel.setBackground(SHStyle.PANEL_BACKGROUND_WHITE);
        headerPanel.setBorder((Border)SHBorderFactory.createMatteBorder((int)0, (int)0, (int)1, (int)0, (Color)Color.LIGHT_GRAY));
        if (headerSize.getHeight() > 0.0) {
            SwingUtil.setSize((JComponent)headerPanel, (Dimension)headerSize);
        }
        ChoiceItemPanel newItemPanel = new ChoiceItemPanel(panel.item, true);
        newItemPanel.setBackground(SHStyle.PANEL_BACKGROUND_WHITE);
        headerPanel.add((Component)this.backToMainMenuButton, 0, 0, 1, 1, 0, 0, 10, 0, (Insets)new ScaledInsets(0, 5, 0, 5));
        headerPanel.add((Component)((Object)newItemPanel), 1, 0, 1, 1, 1, 1, 10, 1);
        targetContentPanel.add((Component)headerPanel, "North");
        GbPanel contentsPanelForChildren = this.getContentPanelFor(((ChoiceItemPanel)panel).item.children);
        JScrollPane scroller = new JScrollPane((Component)contentsPanelForChildren);
        scroller.setBorder(SHBorderFactory.createMatteBorder((int)0, (int)0, (int)1, (int)0, (Color)SHStyle.BORDER_COLOR));
        targetContentPanel.add((Component)scroller, "Center");
        if (headerSize.getHeight() > 0.0) {
            newItemPanel.setSize(new Dimension(headerSize.width, headerSize.height));
        }
        newItemPanel.addNotify();
        newItemPanel.doLayout();
        headerPanel.addNotify();
        headerPanel.doLayout();
        targetContentPanel.doLayout();
        targetContentPanel.validate();
        scroller.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        this.subContentPanel = targetContentPanel;
        if (animate) {
            this.rootComponent.preSlide((Component)((Object)panel), (Component)headerPanel);
            this.rootComponent.setContentComponent(targetContentPanel);
            this.rootComponent.floatComponent((Component)((Object)panel), targetContentPanel.getComponent(0).getLocation());
        } else {
            this.rootComponent.setContentComponent(targetContentPanel, false);
        }
    }

    private void transition(ChoiceItemPanel panel, boolean animate) {
        JPanel targetContentPanel = new JPanel(new BorderLayout());
        Dimension headerSize = panel.getSize();
        GbPanel headerPanel = new GbPanel();
        headerPanel.setBackground(SHStyle.PANEL_BACKGROUND_WHITE);
        headerPanel.setBorder((Border)SHBorderFactory.createMatteBorder((int)0, (int)0, (int)1, (int)0, (Color)Color.LIGHT_GRAY));
        if (headerSize.getHeight() > 0.0) {
            SwingUtil.setSize((JComponent)headerPanel, (Dimension)headerSize);
        }
        ChoiceItemPanel newItemPanel = new ChoiceItemPanel(panel.item, true);
        if (((ChoiceItemPanel)panel).item.parent != null) {
            headerPanel.add((Component)this.backToSubMenuButton, 0, 0, 1, 1, 0, 0, 10, 0, (Insets)new ScaledInsets(0, 5, 0, 5));
        } else {
            headerPanel.add((Component)this.backToMainMenuButton, 0, 0, 1, 1, 0, 0, 10, 0, (Insets)new ScaledInsets(0, 5, 0, 5));
        }
        newItemPanel.setBackground(SHStyle.PANEL_BACKGROUND_WHITE);
        headerPanel.add((Component)((Object)newItemPanel), 1, 0, 1, 1, 1, 1, 10, 1);
        targetContentPanel.add((Component)headerPanel, "North");
        targetContentPanel.add((Component)((ChoiceItemPanel)panel).item.contentPanel, "Center");
        if (headerSize.getHeight() > 0.0) {
            newItemPanel.setSize(new Dimension(headerSize.width, headerSize.height));
        }
        newItemPanel.addNotify();
        newItemPanel.doLayout();
        headerPanel.addNotify();
        headerPanel.doLayout();
        targetContentPanel.doLayout();
        targetContentPanel.validate();
        if (animate) {
            this.rootComponent.preSlide((Component)((Object)panel), (Component)headerPanel);
            this.rootComponent.setContentComponent(targetContentPanel);
            this.rootComponent.floatComponent((Component)((Object)panel), targetContentPanel.getComponent(0).getLocation());
        } else {
            this.rootComponent.setContentComponent(targetContentPanel, false);
        }
        if (this.listener != null) {
            this.listener.transitionedTo(panel.item);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.backToSubMenuButton) {
            this.rootComponent.setContentComponent(this.subContentPanel);
        } else if (e.getSource() == this.backToMainMenuButton) {
            this.rootComponent.setContentComponent(this.startContentPanel);
        }
    }

    public class ChoiceItemPanel
    extends GbPanel {
        private ChoiceItem item;

        public ChoiceItemPanel(ChoiceItem item, boolean isTitle) {
            this.item = item;
            this.initUI(isTitle);
        }

        public void setBackground(Color c) {
            super.setBackground(c);
            for (Component component : this.getComponents()) {
                component.setBackground(c);
            }
        }

        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            dim.height = SimpleHelpLookAndFeel.scale((int)75);
            return dim;
        }

        private void initUI(boolean isTitle) {
            JLabel icon = new JLabel(this.item.icon);
            JLabel title = new JLabel(this.item.name);
            title.setFont(title.getFont().deriveFont(1, SimpleHelpLookAndFeel.scale((float)14.0f)));
            JLabel exampleLabel = new JLabel(" ");
            exampleLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
            if (this.item.example != null) {
                exampleLabel.setText(this.item.example);
            }
            exampleLabel.setFont(SHStyle.smallFont);
            JTextArea description = new JTextArea();
            description.setText(this.item.description);
            description.setBackground(this.getBackground());
            description.setEditable(false);
            description.setEnabled(false);
            description.setWrapStyleWord(true);
            description.setDisabledTextColor(title.getForeground());
            description.setLineWrap(true);
            this.add(title, 1, 0, 1, 1, 1, 0, 10, 2);
            this.add(description, 1, 1, 1, 1, 1, 0, 11, 1);
            this.add(exampleLabel, 1, 2, 1, 1, 1, 0, 11, 1);
            this.add(icon, 0, 0, 1, 3, 0, 0, 10, 1);
            title.setBorder(choiceItemBorderTitle);
            description.setBorder(choiceItemBorderDesc);
            exampleLabel.setBorder(choiceItemBorderExample);
            if (!isTitle) {
                this.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)((SlidingChoiceList)SlidingChoiceList.this).backToSubMenuButton.getPreferredSize().width, (int)0, (int)0));
            }
        }
    }
}

