/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.animated.arrow;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Timer;
import utils.swing.components.animated.arrow.ArrowDrawer;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class ArrowedProgressBar {
    private Timer timer;
    private ArrowDrawer drawer;
    private Dimension size = SimpleHelpLookAndFeel.scale((Dimension)new Dimension(16, 16));
    private int FPS = 25;
    private JComponent rootComponent = new JComponent(){

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (ArrowedProgressBar.this.timer.isRunning()) {
                ArrowedProgressBar.this.paintForeground((Graphics2D)g);
            }
        }
    };

    public JComponent getRootComponent() {
        return this.rootComponent;
    }

    public ArrowedProgressBar() {
        this(null);
    }

    public ArrowedProgressBar(Color foreground) {
        this.timer = new Timer(1000 / this.FPS, new RepaintListener(this.rootComponent));
        this.drawer = foreground != null ? new ArrowDrawer(false, foreground) : new ArrowDrawer(false);
        this.rootComponent.setSize(this.size);
        this.rootComponent.setMaximumSize(this.size);
        this.rootComponent.setPreferredSize(this.size);
        this.rootComponent.setMinimumSize(this.size);
    }

    public void off() {
        this.timer.stop();
        this.rootComponent.repaint();
    }

    public void on() {
        this.timer.start();
    }

    protected void paintForeground(Graphics2D g) {
        int xOffset = this.rootComponent.getWidth() / 2 - this.size.width / 2;
        int yOffset = this.rootComponent.getHeight() / 2 - this.size.height / 2;
        this.drawer.paintForeground(g, xOffset, yOffset, this.rootComponent.getPreferredSize().width, this.rootComponent.getPreferredSize().height);
    }

    public static void main(String[] args) throws InterruptedException {
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        ArrowedProgressBar bar = new ArrowedProgressBar();
        bar.on();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add("Center", bar.getRootComponent());
        frame.getContentPane().add(panel);
        frame.setVisible(true);
        Thread.sleep(1000L);
        bar.off();
    }

    public void setVisible(boolean b) {
        this.rootComponent.setVisible(b);
    }

    public void setBackground(Color backgroundColor) {
        this.rootComponent.setBackground(backgroundColor);
    }

    class RepaintListener
    implements ActionListener {
        WeakReference reference;

        public RepaintListener(JComponent c) {
            this.reference = new WeakReference<JComponent>(c);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComponent jc = (JComponent)this.reference.get();
            if (jc != null) {
                if (jc.isVisible()) {
                    jc.repaint();
                }
            } else {
                ArrowedProgressBar.this.timer.stop();
                ArrowedProgressBar.this.timer.removeActionListener(this);
            }
        }
    }
}

