/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import utils.swing.layout.GbPanel;

public class TitledListView {
    private GbPanel mainContentPanel = new GbPanel();
    private boolean enabled;
    protected ListItem[] items;

    public TitledListView(ListItem[] items) {
        this(items, true);
    }

    public TitledListView(ListItem[] items, boolean showTitles) {
        this.items = items;
        this.initU(items, showTitles);
    }

    public JPanel getRootComponent() {
        return this.mainContentPanel;
    }

    protected JComponent getTitleComponentFor(ListItem item) {
        return new JLabel(item.groupTitle);
    }

    protected void initU(ListItem[] items, boolean showTitles) {
        int Y = 0;
        String oldTitle = null;
        for (int i = 0; i < items.length; ++i) {
            String newTitle = items[i].groupTitle;
            JComponent title = this.getTitleComponentFor(items[i]);
            if (showTitles && (oldTitle == null || !oldTitle.equals(newTitle))) {
                this.newTitleAdded();
                this.mainContentPanel.add((Component)title, 0, Y++, 1, 1, 1, 0, 11, 2);
            }
            this.mainContentPanel.add((Component)items[i].component, 0, Y++, 1, 1, 1, 0, 11, 2);
            if (items[i].shouldBeShown()) {
                items[i].component.setVisible(true);
            } else {
                items[i].component.setVisible(false);
            }
            oldTitle = newTitle;
        }
        JPanel paddy = new JPanel();
        this.mainContentPanel.add((Component)paddy, 0, Y++, 1, 1, 1, 1, 11, 1);
    }

    protected void newTitleAdded() {
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(300, 700);
        ListItem[] items = new ListItem[10];
        for (int i = 0; i < 10; ++i) {
            JPanel redPanel = new JPanel();
            redPanel.setBackground(new Color(i * 25, i * 25, i * 25));
            items[i] = new ListItem("Group " + i, redPanel);
        }
        TitledListView listView = new TitledListView(items, true);
        JScrollPane sp = new JScrollPane(listView.getRootComponent());
        frame.getContentPane().add(sp);
        frame.setVisible(true);
    }

    public static class ListItem {
        public String groupTitle;
        public JComponent component;

        public ListItem(String groupTitle, JComponent component) {
            this.groupTitle = groupTitle;
            this.component = component;
        }

        public boolean shouldBeShown() {
            return true;
        }
    }
}

