/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class ScaledImageLabel
extends JLabel {
    public ScaledImageLabel(ImageIcon icon) {
        super(icon);
    }

    @Override
    protected void paintComponent(Graphics g) {
        ImageIcon icon = (ImageIcon)this.getIcon();
        int iconWidth = icon.getIconWidth();
        int iconHeight = icon.getIconHeight();
        double iconAspect = (double)iconHeight / (double)iconWidth;
        Insets insets = this.getInsets();
        int w = this.getWidth() - insets.left - insets.right;
        int h = this.getHeight() - insets.top - insets.bottom;
        double canvasAspect = (double)h / (double)w;
        int x = 0;
        int y = 0;
        if (iconAspect < canvasAspect) {
            y = h;
            h = (int)((double)w * iconAspect);
            y = (y - h) / 2;
        } else {
            x = w;
            w = (int)((double)h / iconAspect);
            x = (x - w) / 2;
        }
        Image img = icon.getImage();
        g.drawImage(img, x, y, w + x, h + y, 0, 0, iconWidth, iconHeight, null);
    }
}

