/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.color.colorpicker;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;

public class Property<T> {
    final String name;
    T value;
    Vector<PropertyChangeListener> listeners;
    boolean isEnabled = true;
    boolean isUserAdjustable = true;

    public Property(String propertyName) {
        this.name = propertyName;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isUserAdjustable() {
        return this.isUserAdjustable;
    }

    public void setEnabled(boolean b) {
        if (b == this.isEnabled) {
            return;
        }
        this.isEnabled = b;
        this.firePropertyChangeListeners(this.name + ".enabled", new Boolean(!b), new Boolean(b));
    }

    public void setUserAdjustable(boolean b) {
        if (b == this.isUserAdjustable) {
            return;
        }
        this.isUserAdjustable = b;
        this.firePropertyChangeListeners(this.name + ".adjustable", new Boolean(!b), new Boolean(b));
    }

    public final T getValue() {
        return this.value;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean setValue(T obj) {
        this.validateValue(obj);
        if (obj == null && this.value == null) {
            return false;
        }
        if (obj != null && this.value != null && obj.equals(this.value)) {
            return false;
        }
        T oldValue = obj;
        this.value = obj;
        this.firePropertyChangeListeners(this.name, oldValue, this.value);
        return true;
    }

    protected void validateValue(T value) {
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (this.listeners.contains(l)) {
            return;
        }
        this.listeners.add(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.remove(l);
    }

    protected void firePropertyChangeListeners(String propertyName, Object oldValue, Object newValue) {
        if (this.listeners == null) {
            return;
        }
        for (int a = 0; a < this.listeners.size(); ++a) {
            PropertyChangeListener l = this.listeners.get(a);
            try {
                l.propertyChange(new PropertyChangeEvent(this, propertyName, oldValue, newValue));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

