/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.color.colorpicker;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import utils.swing.customlaf.SHStyle;

public class PlafPaintUtils {
    private static Hashtable<String, TexturePaint> verticalGradients;
    private static Hashtable<String, TexturePaint> checkers;

    public static void drawBevel(Graphics2D g, Rectangle r) {
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(SHStyle.BORDER_COLOR);
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    public static Color tween(Color c1, Color c2, float p) {
        int r1 = c1.getRed();
        int g1 = c1.getGreen();
        int b1 = c1.getBlue();
        int a1 = c1.getAlpha();
        int r2 = c2.getRed();
        int g2 = c2.getGreen();
        int b2 = c2.getBlue();
        int a2 = c2.getAlpha();
        return new Color((int)((float)r1 * (1.0f - p) + (float)r2 * p), (int)((float)g1 * (1.0f - p) + (float)g2 * p), (int)((float)b1 * (1.0f - p) + (float)b2 * p), (int)((float)a1 * (1.0f - p) + (float)a2 * p));
    }

    public static TexturePaint getCheckerBoard(int checkerSize) {
        return PlafPaintUtils.getCheckerBoard(checkerSize, Color.white, Color.lightGray);
    }

    public static TexturePaint getCheckerBoard(int checkerSize, Color color1, Color color2) {
        TexturePaint paint;
        String key = checkerSize + " " + color1.toString() + " " + color2.toString();
        if (checkers == null) {
            checkers = new Hashtable();
        }
        if ((paint = checkers.get(key)) == null) {
            BufferedImage bi = new BufferedImage(2 * checkerSize, 2 * checkerSize, 1);
            Graphics2D g = bi.createGraphics();
            g.setColor(color1);
            g.fillRect(0, 0, 2 * checkerSize, 2 * checkerSize);
            g.setColor(color2);
            g.fillRect(0, 0, checkerSize, checkerSize);
            g.fillRect(checkerSize, checkerSize, checkerSize, checkerSize);
            g.dispose();
            paint = new TexturePaint(bi, new Rectangle(0, 0, bi.getWidth(), bi.getHeight()));
            checkers.put(key, paint);
        }
        return paint;
    }
}

