/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.color.colorpicker;

import utils.swing.color.colorpicker.Property;

public class EnumProperty<T>
extends Property<T> {
    T[] values;

    public EnumProperty(String name, T[] values, T defaultValue) {
        super(name);
        this.values = values;
        for (int a = 0; a < values.length; ++a) {
            if (values[a] != null) continue;
            throw new NullPointerException("none of the enum values may be null");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("there were no values");
        }
        this.setValue(defaultValue);
    }

    public T[] getValues() {
        return this.values;
    }

    @Override
    protected void validateValue(Object obj) {
        if (obj == null) {
            throw new NullPointerException("the value must not be null");
        }
        for (int a = 0; a < this.values.length; ++a) {
            if (!this.values[a].equals(obj)) continue;
            return;
        }
        throw new IllegalArgumentException("the value (\"" + obj + "\") did not match any of the allowed values (" + this.listValues() + ")");
    }

    protected String listValues() {
        if (this.values.length == 1) {
            return this.values[0].toString();
        }
        StringBuffer sb = new StringBuffer();
        for (int a = 0; a < this.values.length; ++a) {
            if (a > 0) {
                if (a == this.values.length - 1) {
                    sb.append(" and ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append(this.values[a]);
        }
        return sb.toString();
    }
}

