/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.color.colorpicker;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import utils.swing.color.colorpicker.ColorPicker;
import utils.swing.color.colorpicker.ContextualMenuHelper;
import utils.swing.color.colorpicker.ImageTransferable;
import utils.swing.color.colorpicker.PlafPaintUtils;

public class ColorSwatch
extends JPanel {
    private static final long serialVersionUID = 1L;
    int w;
    public static final String PROPERTY_COPY_CONTEXTUAL_MENU_ITEM = ColorSwatch.class + ".copyContextualMenuItem";
    private static TexturePaint checkerPaint = null;

    public ColorSwatch(int width) {
        this.w = width;
        this.setPreferredSize(new Dimension(width, width));
        this.setMinimumSize(new Dimension(width, width));
        PropertyChangeListener pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ColorSwatch.this.updateContextualMenu();
            }
        };
        this.addPropertyChangeListener(PROPERTY_COPY_CONTEXTUAL_MENU_ITEM, pcl);
        this.updateContextualMenu();
    }

    protected void updateContextualMenu() {
        ContextualMenuHelper.clear(this);
        if (Boolean.TRUE.equals(this.getClientProperty(PROPERTY_COPY_CONTEXTUAL_MENU_ITEM))) {
            String menuItemName = ColorPicker.strings.getObject("Copy").toString();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    BufferedImage image = new BufferedImage(100, 100, 1);
                    Graphics2D g = image.createGraphics();
                    g.setColor(ColorSwatch.this.getBackground());
                    g.fillRect(0, 0, image.getWidth(), image.getHeight());
                    g.dispose();
                    ImageTransferable contents = new ImageTransferable(image);
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(contents, null);
                }
            };
            ContextualMenuHelper.add(this, menuItemName, runnable);
        }
    }

    public ColorSwatch(Color color, int width) {
        this(width);
        this.setForeground(color);
    }

    private static TexturePaint getCheckerPaint() {
        if (checkerPaint == null) {
            int t = 8;
            BufferedImage bi = new BufferedImage(t * 2, t * 2, 1);
            Graphics2D g = bi.createGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, 2 * t, 2 * t);
            g.setColor(Color.lightGray);
            g.fillRect(0, 0, t, t);
            g.fillRect(t, t, t, t);
            checkerPaint = new TexturePaint(bi, new Rectangle(0, 0, bi.getWidth(), bi.getHeight()));
        }
        return checkerPaint;
    }

    @Override
    public void paint(Graphics g0) {
        super.paint(g0);
        Graphics2D g = (Graphics2D)g0;
        Color c = this.getForeground();
        int w2 = Math.min(this.getWidth(), this.w);
        int h2 = Math.min(this.getHeight(), this.w);
        Rectangle r = new Rectangle(this.getWidth() / 2 - w2 / 2, this.getHeight() / 2 - h2 / 2, w2, h2);
        if (c.getAlpha() < 255) {
            TexturePaint checkers = ColorSwatch.getCheckerPaint();
            g.setPaint(checkers);
            g.fillRect(r.x, r.y, r.width, r.height);
        }
        g.setColor(c);
        g.fillRect(r.x, r.y, r.width, r.height);
        PlafPaintUtils.drawBevel(g, r);
    }
}

