/*
 * Decompiled with CFR 0.152.
 */
package utils.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JPanel;
import utils.ostools.OS;
import utils.swing.SwingUtil;
import utils.swing.borders.SimpleShadowBorder;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageHelper;
import utils.switches.Switches;
import utils.switches.oem.OEMSwitches;

public class ScaledShadowImagePanel
extends JPanel
implements MouseListener {
    private Image image;
    private SimpleShadowBorder border = new SimpleShadowBorder();
    private int maxImageWidth = 0;
    private boolean hovered = false;
    private int PADDING = SimpleHelpLookAndFeel.scale((int)10);
    private boolean showHoverZoom = true;
    private boolean showArrows = true;
    private int screenCount = 1;
    private boolean center = false;
    private Color hoverColor = new Color(66, 123, 255);
    private Color borderColor = new Color(33, 66, 200);
    private ShadowPanelListener listener = null;
    private int screen = 0;
    private Icon leftIcon;
    private Icon rightIcon;
    private Icon middleIcon;

    public ScaledShadowImagePanel() {
        this((Image)null);
    }

    public ScaledShadowImagePanel(Image image) {
        this.image = image;
        this.addMouseListener(this);
    }

    public void setHoverImage(Icon leftIcon, Icon rightIcon, Icon middleIcon) {
        this.leftIcon = leftIcon;
        this.rightIcon = rightIcon;
        this.middleIcon = middleIcon;
    }

    public void setShadowPanelListener(ShadowPanelListener listener) {
        this.listener = listener;
    }

    public void setShowHoverZoom(boolean showHoverZoom) {
        this.showHoverZoom = showHoverZoom;
    }

    public void setColor(Color fillColor, Color borderColor) {
        this.hoverColor = fillColor;
        this.borderColor = borderColor;
    }

    public void setCenter(boolean center) {
        this.center = center;
    }

    public void useDarkerBorder() {
        this.border = new SimpleShadowBorder(true);
    }

    public void setWidth(int width) {
        this.maxImageWidth = width;
    }

    public void setImage(Image image) {
        this.image = image;
        if (image == null) {
            this.setVisible(false);
        }
        this.repaint();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.image == null) {
            return new Dimension(SimpleHelpLookAndFeel.scale((int)200), SimpleHelpLookAndFeel.scale((int)200) / 4 * 3);
        }
        int imageWidth = SimpleHelpLookAndFeel.scale((int)this.image.getWidth(null));
        if (this.maxImageWidth > 0) {
            imageWidth = Math.min(imageWidth, this.maxImageWidth);
        }
        int imageHeight = this.getImageHeightForWidth(imageWidth);
        return new Dimension(2 * this.PADDING + imageWidth, 2 * this.PADDING + imageHeight);
    }

    private int getImageHeightForWidth(int imageWidth) {
        double ratio = this.image.getWidth(null);
        return (int)((double)imageWidth / (ratio /= (double)this.image.getHeight(null)));
    }

    public void setSelectedScreen(int screen) {
        this.screen = screen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        double factor = 1.0;
        if (OS.isOSXRetina()) {
            factor = 2.0;
        }
        Graphics2D g2d = (Graphics2D)g;
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int maxWidth = this.getWidth() - 2 * this.PADDING;
        int maxHeight = this.getHeight() - 2 * this.PADDING;
        if (this.image != null) {
            Dimension preferredSize = this.getPreferredSize();
            preferredSize.width -= 2 * this.PADDING;
            preferredSize.height -= 2 * this.PADDING;
            Dimension actualSize = ImageHelper.getDimensionToFitInside((Dimension)preferredSize, (int)maxWidth, (int)maxHeight);
            this.snapDimensionToImageSizeIfClose(actualSize);
            int imageW = (int)((double)actualSize.width * factor);
            int imageH = (int)((double)actualSize.height * factor);
            int off = (int)((factor * (double)this.getWidth() - (double)imageW) / 2.0);
            int voff = (int)(factor * (double)this.PADDING);
            if (this.center) {
                voff = (int)((factor * (double)this.getHeight() - (double)imageH) / 2.0);
            }
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            AffineTransform t = SwingUtil.prepareForRetina((Graphics2D)g2d);
            try {
                this.border.paintBorder(null, (Graphics)g2d, off, voff, imageW, imageH);
                BufferedImage bufferedImage = ImageHelper.scaleDownToFitExactly((BufferedImage)ImageHelper.toBufferedImageRGB((Image)this.image), (int)imageW, (int)imageH, (boolean)true);
                if (bufferedImage != null) {
                    g2d.drawImage((Image)bufferedImage, off, voff, null);
                }
            }
            finally {
                g2d.setTransform(t);
            }
            BasicStroke outerStroke = new BasicStroke(4.0f, 1, 1);
            BasicStroke outerStrokeGrey = new BasicStroke(1.0f, 1, 1);
            if (this.hovered && this.showHoverZoom) {
                if (this.middleIcon != null) {
                    int iconWidth = this.middleIcon.getIconWidth();
                    int iconHeight = this.middleIcon.getIconHeight();
                    this.middleIcon.paintIcon(null, g2d, (this.getWidth() - iconWidth) / 2, (this.getHeight() - iconHeight) / 2);
                } else {
                    g2d.setColor(this.hoverColor);
                    g2d.setStroke(outerStroke);
                    int centreX = (int)((double)(off + imageW / 2) / factor);
                    int centreY = (int)((double)(voff + imageH / 2) / factor);
                    int circleD = SimpleHelpLookAndFeel.scale((int)40);
                    Ellipse2D.Double circle = new Ellipse2D.Double(centreX - circleD / 2, centreY - circleD / 2, circleD, circleD);
                    g2d.setColor(new Color(200, 200, 200, 100));
                    g2d.fill(circle);
                    if (OEMSwitches.DARK_THEME) {
                        g2d.setColor(this.hoverColor);
                    } else {
                        g2d.setColor(this.borderColor);
                    }
                    g2d.draw(circle);
                    int startLineX = (int)((double)centreX + Math.sin(2.356194490192345) * (double)circleD / 2.0);
                    int startLineY = (int)((double)centreY - Math.cos(2.356194490192345) * (double)circleD / 2.0);
                    g2d.drawLine(startLineX, startLineY, startLineX + SimpleHelpLookAndFeel.scale((int)20), startLineY + SimpleHelpLookAndFeel.scale((int)20));
                }
            }
            if (this.hovered && this.showArrows) {
                if (this.leftIcon != null && this.rightIcon != null) {
                    this.leftIcon.paintIcon(null, g2d, SimpleHelpLookAndFeel.scale((int)30), (this.getHeight() - this.leftIcon.getIconWidth()) / 2);
                    this.rightIcon.paintIcon(null, g2d, this.getWidth() - SimpleHelpLookAndFeel.scale((int)30) - this.rightIcon.getIconWidth(), (this.getHeight() - this.rightIcon.getIconWidth()) / 2);
                } else {
                    AffineTransform transform = g2d.getTransform();
                    try {
                        g2d.setStroke(outerStrokeGrey);
                        g2d.translate(SimpleHelpLookAndFeel.scale((int)30), this.getHeight() / 2);
                        g2d.rotate(Math.PI);
                        this.drawArrow(g2d);
                        g2d.rotate(Math.PI);
                        g2d.translate(this.getWidth() - SimpleHelpLookAndFeel.scale((int)60), 0);
                        this.drawArrow(g2d);
                    }
                    finally {
                        g2d.setTransform(transform);
                    }
                }
                int gapWidth = SimpleHelpLookAndFeel.scale((int)20);
                int widthRequired = (this.screenCount - 1) * gapWidth;
                if (this.screenCount > 1) {
                    for (int i = 0; i < this.screenCount; ++i) {
                        int size = SimpleHelpLookAndFeel.scale((int)12);
                        int x = this.getWidth() / 2 - widthRequired / 2 + gapWidth * i - size / 2;
                        int y = this.getHeight() - SimpleHelpLookAndFeel.scale((int)30);
                        AffineTransform old = g2d.getTransform();
                        try {
                            g2d.translate(x, y);
                            x = 0;
                            y = 0;
                            if (i == this.screen) {
                                g2d.setColor(Color.GRAY);
                                g2d.fillArc(x, y, size, size, 0, 360);
                                continue;
                            }
                            g2d.setColor(Color.LIGHT_GRAY);
                            g2d.fillArc(x, y, size, size, 0, 360);
                            g2d.setColor(Color.GRAY);
                            g2d.drawArc(x, y, size, size, 0, 360);
                            continue;
                        }
                        finally {
                            g2d.setTransform(old);
                        }
                    }
                }
            }
        } else {
            g.setColor(new Color(100, 100, 100));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private void snapDimensionToImageSizeIfClose(Dimension d) {
        if (!Switches.SH_allowBlockyUpscalingInScreenshots) {
            return;
        }
        if (d.width == this.image.getWidth(null)) {
            return;
        }
        int w = d.width;
        double ratio = (double)w / (double)this.image.getWidth(null);
        double snapFactor = 0.3;
        if (ratio > 1.0) {
            if (ratio % 1.0 < snapFactor) {
                ratio = Math.floor(ratio);
                d.setSize(this.image.getWidth(null) * (int)ratio, this.image.getHeight(null) * (int)ratio);
            }
        } else {
            ratio = (double)this.image.getWidth(null) / (double)w;
            if (ratio % 1.0 > snapFactor) {
                ratio = Math.ceil(ratio);
                d.setSize(this.image.getWidth(null) / (int)ratio, this.image.getHeight(null) / (int)ratio);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.listener == null) {
            return;
        }
        if (e.getX() < SimpleHelpLookAndFeel.scale((int)60) && this.showArrows) {
            --this.screen;
            if (this.screen < 0) {
                this.screen = this.screenCount - 1;
            }
            this.repaint();
            this.listener.leftPressed();
            return;
        }
        if (e.getX() > this.getWidth() - SimpleHelpLookAndFeel.scale((int)60) && this.showArrows) {
            ++this.screen;
            if (this.screen >= this.screenCount) {
                this.screen = 0;
            }
            this.listener.rightPressed();
            return;
        }
        this.listener.zoomPressed();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.showHoverZoom || this.showArrows) {
            this.hovered = true;
            this.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.showHoverZoom || this.showArrows) {
            this.hovered = false;
            this.repaint();
        }
    }

    private void drawArrow(Graphics2D g2d) {
        int xOffset = -10;
        int yBuffer = 4;
        int size = 24;
        g2d.setColor(this.borderColor);
        g2d.fillArc(xOffset, -size / 2, size, size, 0, 360);
        g2d.setColor(this.hoverColor);
        g2d.setStroke(new BasicStroke(2.0f, 1, 1));
        g2d.drawLine(xOffset + size / 3 + 2, -size / 2 + yBuffer, xOffset + 2 * size / 3, 0);
        g2d.drawLine(xOffset + 2 * size / 3, 0, xOffset + size / 3 + 2, size / 2 - yBuffer);
    }

    public void setShowArrows(boolean b, int screenCount, int screenSelection) {
        this.screen = screenSelection;
        this.showArrows = b;
        this.screenCount = screenCount;
    }

    public int getSelectedScreen() {
        return this.screen;
    }

    public static interface ShadowPanelListener {
        public void zoomPressed();

        public void leftPressed();

        public void rightPressed();
    }
}

