/*
 * Decompiled with CFR 0.152.
 */
package utils.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import javax.swing.ImageIcon;
import utils.ostools.OS;
import utils.swing.SwingUtil;

public class RetinaImageIcon
extends ImageIcon {
    public RetinaImageIcon(Image image) {
        super(image);
    }

    @Override
    public int getIconWidth() {
        if (OS.isOSXRetina()) {
            return super.getIconWidth() / 2;
        }
        return super.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        if (OS.isOSXRetina()) {
            return super.getIconHeight() / 2;
        }
        return super.getIconHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform t = SwingUtil.prepareForRetina((Graphics2D)g2d);
        try {
            if (OS.isOSXRetina()) {
                super.paintIcon(c, g2d, x * 2, y * 2);
            } else {
                super.paintIcon(c, g2d, x, y);
            }
        }
        finally {
            g2d.setTransform(t);
        }
    }
}

