/*
 * Decompiled with CFR 0.152.
 */
package utils.stream;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import utils.stream.StreamUtils;

public class URLConnectionUtil {
    public static void drainErrorStreamToMaintain(Throwable error, URLConnection failedUrlConnection) {
        if (error instanceof IOException && failedUrlConnection != null) {
            try {
                InputStream es = ((HttpURLConnection)failedUrlConnection).getErrorStream();
                if (es != null) {
                    StreamUtils.readAllAndDispose((InputStream)es);
                    es.close();
                }
            }
            catch (IOException | NullPointerException exception) {
                // empty catch block
            }
        }
    }

    public static void dumpResponseHeaders(URLConnection conn) {
        Object[] keys;
        String addCookie = conn.getHeaderField("Set-Cookie");
        System.out.println("[URLConnection] Cookies: " + addCookie);
        Map<String, List<String>> map = conn.getHeaderFields();
        for (Object key : keys = map.keySet().toArray()) {
            System.out.println("[URLConnection] Header: " + key + "=" + map.get(key));
        }
    }

    public static boolean isRedirected(URLConnection conn) {
        String loc = conn.getHeaderField("location");
        return loc != null;
    }

    public static String getRedirect(URLConnection conn) {
        String loc = conn.getHeaderField("location");
        return loc;
    }

    public static URLConnection connectAndFollowRedirects(URLConnection conn) throws IOException {
        String cookies = conn.getRequestProperty("cookie");
        conn.connect();
        int maxRedirects = 30;
        int N = 0;
        while (URLConnectionUtil.isRedirected(conn)) {
            if (++N >= maxRedirects) {
                throw new IOException("Too many redirects (>" + maxRedirects + ")");
            }
            String redirectURL = URLConnectionUtil.getRedirect(conn);
            System.out.println("[URLConnectionUtil] Redirected to: " + redirectURL);
            URLConnection nextconn = new URL(redirectURL).openConnection();
            nextconn.setRequestProperty("cookie", cookies);
            nextconn.connect();
            conn = nextconn;
        }
        return conn;
    }
}

