/*
 * Decompiled with CFR 0.152.
 */
package utils.stream;

import java.io.File;
import java.io.FileOutputStream;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import utils.progtools.StackTracer;
import utils.string.Padder;

public class SocketLeaks {
    static boolean ON = false;
    static Object LOCK = new Object();
    static HashMap<Socket, TrackedSocket> map = new HashMap();
    static SimpleDateFormat sdf = new SimpleDateFormat("dd-MM HH:mm:ss");
    static File dumpto;

    public static void trackSocketLeaks(boolean b) {
        ON = b;
    }

    public static void dumpToFile(File file) {
        dumpto = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void track(Socket sock) {
        if (sock == null) {
            return;
        }
        if (!ON) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            map.put(sock, new TrackedSocket(sock));
            SocketLeaks.associate(sock, "Addr", sock.getRemoteSocketAddress() + "");
            SocketLeaks.associate(sock, "Created", sdf.format(new Date()));
            SocketLeaks.associate(sock, "Trace", StackTracer.getStacktrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replace(Socket sock, Socket wrapper) {
        if (sock == null) {
            return;
        }
        if (wrapper == null) {
            return;
        }
        if (!ON) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            TrackedSocket tsock = map.remove(sock);
            if (tsock != null) {
                tsock.socket = wrapper;
                map.put(wrapper, tsock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void associate(Socket sock, String key, String value) {
        if (sock == null) {
            return;
        }
        if (!ON) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            TrackedSocket tsock = map.get(sock);
            if (tsock == null) {
                SocketLeaks.track(sock);
                tsock = map.get(sock);
            }
            tsock.infos.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clean() {
        Object object = LOCK;
        synchronized (object) {
            if (!ON) {
                if (map.size() > 0) {
                    map = new HashMap();
                }
            } else {
                Socket[] keys;
                for (Socket sock : keys = map.keySet().toArray(new Socket[0])) {
                    TrackedSocket ts = map.get(sock);
                    if (ts == null) {
                        map.remove(sock);
                        continue;
                    }
                    if (ts.isAlive()) continue;
                    map.remove(ts.socket);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printLeakages(long considerLeakAfterMs) {
        if (!ON) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            TrackedSocket[] list;
            long T = System.currentTimeMillis();
            ArrayList<String> lines = new ArrayList<String>();
            for (TrackedSocket ts : list = map.values().toArray(new TrackedSocket[0])) {
                if (!ts.isAlive()) {
                    map.remove(ts.socket);
                    continue;
                }
                if (T - ts.created < considerLeakAfterMs) continue;
                StringBuffer sb = new StringBuffer();
                sb.append("[TrackedSocket] ");
                long minsold = (T - ts.created) / 60000L;
                sb.append(Padder.padStart(minsold + "", 3) + " mins, ");
                Object[] keys = ts.infos.keySet().toArray(new String[0]);
                Arrays.sort(keys);
                for (Object info : keys) {
                    String value = ts.infos.get(info);
                    sb.append((String)info).append(":").append(value).append(", ");
                }
                sb.setLength(sb.length() - 1);
                sb.append("\n");
                lines.add(sb.toString());
            }
            StringBuffer sb = new StringBuffer();
            sb.append("[TrackedSocket] Socket Tracking Printout (n=" + map.size() + ")\n");
            Collections.sort(lines);
            for (String line : lines) {
                sb.append(line);
            }
            if (dumpto != null) {
                try (FileOutputStream fout = new FileOutputStream(dumpto);){
                    fout.write(sb.toString().getBytes());
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            } else {
                System.out.println(sb.toString());
            }
        }
    }

    private static class TrackedSocket {
        long created = System.currentTimeMillis();
        Socket socket;
        HashMap<String, String> infos = new HashMap();

        public TrackedSocket(Socket sock) {
            this.socket = sock;
        }

        public boolean isAlive() {
            if (this.socket.isClosed()) {
                return false;
            }
            return System.currentTimeMillis() - this.created <= 60000L || this.socket.isConnected();
        }
    }
}

