/*
 * Decompiled with CFR 0.152.
 */
package utils.stream;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import utils.stream.LimitedBandwidthProvider;

public class LimitedBandwidthOutputStream
extends FilterOutputStream {
    static boolean LIMIT_WRITE_SIZE = false;
    OutputStream out;
    double sleepFactor;
    LimitedBandwidthProvider provider;
    long timing = 100L;
    long cumulativeTime = 0L;

    public LimitedBandwidthOutputStream(OutputStream out) {
        this(out, 50);
    }

    public LimitedBandwidthOutputStream(OutputStream out, int pc) {
        super(out);
        this.out = out;
        if (pc > 100) {
            pc = 100;
        }
        if (pc < 20) {
            pc = 20;
        }
        this.setPercentBW(pc);
    }

    public void setLimitedBandwidthProvider(LimitedBandwidthProvider provider) {
        this.provider = provider;
    }

    public void setPercentBW(int pc) {
        double percentBW = pc;
        double sleepFactor = 1.0 - (percentBW /= 100.0);
        sleepFactor /= 1.0 - sleepFactor;
        this.sleepFactor = sleepFactor;
    }

    private void didWrite(long nanos) {
        this.cumulativeTime += nanos;
        long millis = this.cumulativeTime / 1000000L;
        if (millis > this.timing) {
            if (this.provider != null) {
                this.setPercentBW(this.provider.getPercentBwUsage());
            }
            if (this.sleepFactor > 0.0) {
                long sleep = (long)((double)millis * this.sleepFactor);
                this.cumulativeTime = 0L;
                try {
                    long T = System.nanoTime();
                    Thread.sleep(sleep);
                    T = System.nanoTime() - T;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (LIMIT_WRITE_SIZE) {
            int N = 10000;
            while (len > N) {
                long t = System.nanoTime();
                this.out.write(b, off, N);
                t = System.nanoTime() - t;
                this.didWrite(t);
                off += N;
                len -= N;
                if (t >= 30L) continue;
                N *= 2;
            }
            this.out.write(b, off, len);
        } else {
            long t = System.nanoTime();
            this.out.write(b, off, len);
            t = System.nanoTime() - t;
            this.didWrite(t);
        }
    }

    @Override
    public void write(int b) throws IOException {
        long t = System.nanoTime();
        this.out.write(b);
        t = System.nanoTime() - t;
        this.didWrite(t);
    }
}

