/*
 * Decompiled with CFR 0.152.
 */
package utils.stream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import utils.stream.LimitedCpuInputStream;
import utils.stream.LimitedCpuOutputStream;

public class GZIPer {
    public static byte[] compressString(String s, double cpuUsage) throws IOException {
        return GZIPer.compress(s.getBytes(StandardCharsets.UTF_8), cpuUsage);
    }

    public static String decompressString(byte[] dat, double cpuUsage) throws IOException {
        return new String(GZIPer.decompress(dat, cpuUsage), StandardCharsets.UTF_8);
    }

    public static byte[] compress(byte[] dat, double cpuUsage) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        GZIPOutputStream gzout = new GZIPOutputStream(bout);
        LimitedCpuOutputStream cpuout = new LimitedCpuOutputStream(gzout, cpuUsage);
        cpuout.write(dat, 0, dat.length);
        gzout.finish();
        cpuout.close();
        return bout.toByteArray();
    }

    public static byte[] decompress(byte[] dat, double cpuUsage) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(dat);
        GZIPInputStream gzin = new GZIPInputStream(bin);
        LimitedCpuInputStream cpuin = new LimitedCpuInputStream(gzin, cpuUsage);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[50000];
        int n = 0;
        while (n != -1) {
            n = cpuin.read(buf, 0, 50000);
            if (n <= 0) continue;
            bout.write(buf, 0, n);
        }
        gzin.close();
        return bout.toByteArray();
    }
}

