/*
 * Decompiled with CFR 0.152.
 */
package utils.software.windows;

import com.aem.utils.com.Dispatch;
import com.aem.utils.com.Variant;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import utils.osstats.winutils.WMIRegistry;
import utils.osstats.winutils.WMIResults;
import utils.software.types.category.SoftwareCategory;
import utils.software.types.software.AbstractSoftware;
import utils.software.windows.WindowsApplication;
import utils.software.windows.WindowsHotFix;
import utils.software.windows.WindowsUpdate;

public class WindowsSoftware
extends AbstractSoftware<WindowsApplication, WindowsUpdate> {
    private final SoftwareCategory<WindowsHotFix> hotfixes = new SoftwareCategory<WindowsHotFix>(WindowsHotFix.class);

    public WindowsSoftware() {
        super(WindowsApplication.class, WindowsUpdate.class);
        this.allCategories.add(this.hotfixes);
    }

    public void addHotfix(WindowsHotFix hotFix) {
        this.hotfixes.addApplication(hotFix);
    }

    public boolean hasHotfixDetails() {
        return this.hotfixes.getRecursiveApplicationCount() > 0;
    }

    public Iterable<WindowsHotFix> getHotFixes() {
        return new SoftwareCategory.ApplicationsIterator<WindowsHotFix>(this.hotfixes);
    }

    public ArrayList<WindowsHotFix> getHotFixesArray() {
        return WindowsSoftware.getAsArray(this.getHotFixes());
    }

    @Override
    public void updateCurrentlyInstalledApps() {
        String[] keyParents;
        super.updateCurrentlyInstalledApps();
        Pattern genericDateFormat = Pattern.compile("([\\d])+[^\\d]([\\d]+)[^\\d]([\\d]+)");
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd");
        for (String keyParent : keyParents = new String[]{"Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall", "Software\\Wow6432Node\\Microsoft\\Windows\\CurrentVersion\\Uninstall"}) {
            String[] children;
            for (String childKey : children = WMIRegistry.getProvider().regGetChildren("HKLM", keyParent)) {
                WindowsApplication app = new WindowsApplication();
                app.applicationName = WMIRegistry.getProvider().regGet("HKLM", keyParent + "\\" + childKey, "DisplayName");
                if (app.applicationName == null || app.applicationName.trim().length() == 0) continue;
                app.appVersion = WMIRegistry.getProvider().regGet("HKLM", keyParent + "\\" + childKey, "DisplayVersion");
                app.path = WMIRegistry.getProvider().regGet("HKLM", keyParent + "\\" + childKey, "InstallLocation");
                app.vendor = WMIRegistry.getProvider().regGet("HKLM", keyParent + "\\" + childKey, "Publisher");
                String date = WMIRegistry.getProvider().regGet("HKLM", keyParent + "\\" + childKey, "InstallDate");
                try {
                    app.installDate = 0L;
                    if (date != null && date.length() > 0) {
                        app.installDate = sdf.parse(date).getTime();
                    }
                }
                catch (Exception ex) {
                    app.installDate = 0L;
                    ex.printStackTrace();
                }
                this.apps.addApplication(app);
            }
        }
        WMIResults wmiResults = WMIRegistry.getProvider().queryWMI("SELECT HotFixID,InstalledOn,Description,Caption from Win32_QuickFixEngineering");
        for (Properties prop : wmiResults.getProperties()) {
            WindowsHotFix fix = new WindowsHotFix();
            fix.hotFixID = prop.getProperty("HotFixID");
            fix.description = prop.getProperty("Description");
            fix.caption = prop.getProperty("Caption");
            String installedOn = prop.getProperty("InstalledOn");
            if (installedOn != null) {
                try {
                    Matcher matcher = genericDateFormat.matcher(installedOn);
                    if (matcher.matches()) {
                        Calendar instance;
                        int first = Integer.parseInt(matcher.group(1));
                        int second = Integer.parseInt(matcher.group(2));
                        int third = Integer.parseInt(matcher.group(3));
                        if (first > 2000) {
                            instance = Calendar.getInstance();
                            instance.set(1, first);
                            instance.set(2, second - 1);
                            instance.set(5, third);
                            fix.installedOn = instance.getTimeInMillis();
                        } else {
                            instance = Calendar.getInstance();
                            instance.set(1, third);
                            instance.set(2, second - 1);
                            instance.set(5, first);
                            fix.installedOn = instance.getTimeInMillis();
                        }
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            this.hotfixes.addApplication(fix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePreviouslyInstalledApps() {
        super.updatePreviouslyInstalledApps();
        Dispatch dispatch = new Dispatch("Microsoft.Update.Session");
        try {
            int count;
            Variant v = dispatch.invoke("CreateUpdateSearcher", 3);
            Dispatch updateSearcher = v.variantToDispatch();
            v = updateSearcher.invoke("GetTotalHistoryCount", 3);
            int totalHistoryCount = v.getAsInteger();
            for (int currentIndex = 0; currentIndex < totalHistoryCount; currentIndex += count) {
                count = Math.min(1000, totalHistoryCount - currentIndex);
                Dispatch queryHistory = updateSearcher.invoke("QueryHistory", 3, currentIndex, count).variantToDispatch();
                int returnedCount = queryHistory.get("Count").getAsInteger();
                for (int i = 0; i < returnedCount; ++i) {
                    Dispatch item = queryHistory.invoke("Item", 3, i).variantToDispatch();
                    WindowsApplication app = new WindowsApplication();
                    app.applicationName = item.get("Title").getAsString();
                    app.installDate = WindowsSoftware.convertWindowsTimeToMilliseconds(item.get("Date").getAsDate());
                    app.description = item.get("Description").getAsString();
                    app.url = item.get("SupportUrl").getAsString();
                    app.statusCode = (byte)item.get("ResultCode").getAsInteger();
                    String clientID = item.get("ClientApplicationID").getAsString();
                    this.apps.addApplication(app);
                }
            }
        }
        finally {
            try {
                dispatch.cleanup();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private static long convertWindowsTimeToMilliseconds(long comTime) {
        Calendar cal = Calendar.getInstance();
        cal.set(1899, 11, 30);
        cal.add(6, (int)comTime);
        return cal.getTimeInMillis();
    }
}

