/*
 * Decompiled with CFR 0.152.
 */
package utils.software.types.software;

import java.util.ArrayList;
import utils.message.Message;
import utils.software.types.AbstractApplication;
import utils.software.types.AbstractUpdate;
import utils.software.types.Application;
import utils.software.types.category.SoftwareCategory;
import utils.software.types.software.Software;

public abstract class AbstractSoftware<T extends AbstractApplication, U extends AbstractUpdate>
implements Software<T, U> {
    protected static final byte VERSION = 0;
    protected final ArrayList<SoftwareCategory<? extends Application>> allCategories = new ArrayList();
    protected final SoftwareCategory<T> apps;
    protected final SoftwareCategory<U> updates;
    protected long collectionTime;

    public AbstractSoftware(Class<T> tClass, Class<U> uClass) {
        this.apps = new SoftwareCategory<T>(tClass);
        this.updates = new SoftwareCategory<U>(uClass);
        this.allCategories.add(this.apps);
        this.allCategories.add(this.updates);
    }

    @Override
    public boolean hasApplicationDetails() {
        return this.apps.getRecursiveApplicationCount() > 0;
    }

    @Override
    public boolean hasUpdateDetails() {
        return this.updates.getRecursiveApplicationCount() > 0;
    }

    @Override
    public Iterable<T> getApplications() {
        return new SoftwareCategory.ApplicationsIterator<T>(this.apps);
    }

    @Override
    public ArrayList<T> getApplicationsArray() {
        return AbstractSoftware.getAsArray(this.getApplications());
    }

    @Override
    public Iterable<U> getUpdates() {
        return new SoftwareCategory.ApplicationsIterator<U>(this.updates);
    }

    @Override
    public ArrayList<U> getUpdatesArray() {
        return AbstractSoftware.getAsArray(this.getUpdates());
    }

    public void updateCurrentlyInstalledApps() {
        this.collectionTime = System.currentTimeMillis();
    }

    public void updatePreviouslyInstalledApps() {
        this.collectionTime = System.currentTimeMillis();
    }

    @Override
    public void saveToMessage(Message m) {
        m.append((byte)0);
        for (SoftwareCategory<? extends Application> category : this.allCategories) {
            category.saveToMessage(m);
        }
    }

    @Override
    public void loadFromMessage(Message m) {
        byte version = m.getNextByte();
        for (SoftwareCategory<? extends Application> category : this.allCategories) {
            category.loadFromMessage(m, version);
        }
    }

    public static <TT extends Application> ArrayList<TT> getAsArray(Iterable<TT> iterable) {
        ArrayList<Application> list = new ArrayList<Application>();
        for (Application app : iterable) {
            list.add(app);
        }
        return list;
    }

    public void addApplication(T app) {
        this.apps.addApplication(app);
    }

    public void addUpdate(U app) {
        this.updates.addApplication(app);
    }

    @Override
    public long getCollectionTime() {
        return this.collectionTime;
    }
}

