/*
 * Decompiled with CFR 0.152.
 */
package utils.software.types;

import utils.message.Message;
import utils.software.linux.LinuxUpdate;
import utils.software.macos.OSXUpdate;
import utils.software.types.Application;
import utils.software.windows.WindowsUpdate;

public class AbstractUpdate
implements Application {
    public String id;
    public String name;
    public String updateVersion;
    public boolean isRecommended;
    public boolean restartRequired;

    public String toString() {
        return "Update [" + this.isRecommended + "][" + this.restartRequired + "] " + this.name + " (" + this.updateVersion + ")";
    }

    public void saveToMessage(Message m) {
        m.append(this.id);
        m.append(this.name);
        m.append(this.updateVersion);
        m.append(this.isRecommended);
        m.append(this.restartRequired);
    }

    public void loadFromMessage(Message m, byte version) {
        this.id = m.getNextString();
        this.name = m.getNextString();
        this.updateVersion = m.getNextString();
        this.isRecommended = m.getNextBoolean();
        this.restartRequired = m.getNextBoolean();
    }

    @Override
    public Message toMessage() {
        Message m = null;
        if (this instanceof WindowsUpdate) {
            m = new Message(1);
        } else if (this instanceof OSXUpdate) {
            m = new Message(2);
        } else if (this instanceof LinuxUpdate) {
            m = new Message(3);
        }
        this.saveToMessage(m);
        return m;
    }

    public static AbstractUpdate fromMessage(Message m, byte version) {
        int type = m.getType();
        AbstractUpdate app = null;
        if (type == 1) {
            app = new WindowsUpdate();
        } else if (type == 2) {
            app = new OSXUpdate();
        } else if (type == 3) {
            app = new LinuxUpdate();
        }
        ((AbstractUpdate)app).loadFromMessage(m, version);
        return app;
    }
}

