/*
 * Decompiled with CFR 0.152.
 */
package utils.software.macos;

import java.util.Date;
import utils.ostools.RunCommandGetOutput;
import utils.plist.PListArray;
import utils.plist.PListDict;
import utils.plist.PListException;
import utils.plist.PListObject;
import utils.plist.PListParser;
import utils.software.macos.OSXApplication;
import utils.software.macos.OSXUpdate;
import utils.software.types.software.AbstractSoftware;
import utils.string.StringUtil;

public class OSXSoftware
extends AbstractSoftware<OSXApplication, OSXUpdate> {
    public OSXSoftware() {
        super(OSXApplication.class, OSXUpdate.class);
    }

    @Override
    public void updatePreviouslyInstalledApps() {
        super.updatePreviouslyInstalledApps();
        this.apps.clear();
        String output = RunCommandGetOutput.runCommandGetOutput((String[])new String[]{"system_profiler", "SPInstallHistoryDataType", "-xml"})[0];
        try {
            PListObject parse = PListParser.parse((String)output);
            PListArray items = ((PListArray)parse).getPListDict(0).getPListArray("_items");
            for (int i = 0; i < items.size(); ++i) {
                OSXApplication app = new OSXApplication();
                PListDict item = items.getPListDict(i);
                try {
                    app.applicationName = item.getString("_name", null);
                    Date installDate = item.getDate("install_date", null);
                    if (installDate != null) {
                        app.lastModified = installDate.getTime();
                    }
                    app.appVersion = item.getString("install_version", null);
                    String source = item.getString("package_source", null);
                    if (source != null) {
                        if (source.equalsIgnoreCase("package_source_apple")) {
                            app.obtainedFrom = 1;
                        } else if (source.equalsIgnoreCase("package_source_other")) {
                            app.obtainedFrom = (byte)3;
                        }
                    }
                    this.apps.addApplication(app);
                    continue;
                }
                catch (PListException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (PListException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateCurrentlyInstalledApps() {
        super.updateCurrentlyInstalledApps();
        String output = RunCommandGetOutput.runCommandGetOutput((String[])new String[]{"system_profiler", "SPApplicationsDataType", "-xml"})[0];
        this.apps.clear();
        try {
            PListObject parse = PListParser.parse((String)output);
            PListArray items = ((PListArray)parse).getPListDict(0).getPListArray("_items");
            for (int i = 0; i < items.size(); ++i) {
                OSXApplication app = new OSXApplication();
                PListDict item = items.getPListDict(i);
                try {
                    int colon;
                    String signedBy;
                    PListArray signedArray;
                    String obtainedFrom;
                    Date lastModified;
                    app.applicationName = item.getString("_name", null);
                    app.path = item.getString("path", null);
                    app.appVersion = item.getString("version", null);
                    String has64bit = item.getString("has64BitIntelCode", null);
                    if (has64bit != null) {
                        app.is64bit = StringUtil.stringIsTrue((String)has64bit) ? (byte)1 : (byte)2;
                    }
                    if ((lastModified = item.getDate("lastModified", null)) != null) {
                        app.lastModified = lastModified.getTime();
                    }
                    if ((obtainedFrom = item.getString("obtained_from", null)) != null) {
                        app.obtainedFrom = OSXSoftware.toObtainedFrom(obtainedFrom);
                        if (app.obtainedFrom == 1) {
                            app.vendor = "Apple";
                        }
                    }
                    app.type = OSXSoftware.toKind(item.getString("runtime_environment", null));
                    if (app.obtainedFrom == 3 && (signedArray = item.getPListArray("signed_by")) != null && (signedBy = signedArray.get(0).getString(null)) != null && (colon = signedBy.indexOf(58)) != -1) {
                        app.vendor = signedBy.substring(colon + 1).trim();
                    }
                    this.apps.addApplication(app);
                    continue;
                }
                catch (PListException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (PListException e) {
            e.printStackTrace();
        }
    }

    private static byte toObtainedFrom(String string) {
        if (string.equals("identified_developer")) {
            return 3;
        }
        if (string.equals("apple")) {
            return 1;
        }
        if (string.equals("mac_app_store")) {
            return 2;
        }
        return 0;
    }

    private static byte toKind(String string) {
        if (string.equals("arch_x86")) {
            return 2;
        }
        return 1;
    }
}

