/*
 * Decompiled with CFR 0.152.
 */
package utils.software.macos;

import utils.message.Message;
import utils.software.types.AbstractApplication;

public class OSXApplication
extends AbstractApplication {
    public static final byte TYPE_UNKNOWN = 0;
    public static final byte TYPE_PPC = 1;
    public static final byte TYPE_INTEL = 2;
    public static final byte IS64_UNKNOWN = 0;
    public static final byte IS64_YES = 1;
    public static final byte IS64_NO = 2;
    public static final byte OBTAINED_UNKNOWN = 0;
    public static final byte OBTAINED_APPLE = 1;
    public static final byte OBTAINED_MAC_APP_STORE = 2;
    public static final byte OBTAINED_IDENTIFIED_DEVELOPER = 3;
    public byte type;
    public byte is64bit;
    public long lastModified;
    public byte obtainedFrom;

    @Override
    public void saveToMessage(Message m) {
        super.saveToMessage(m);
        m.append(this.type);
        m.append(this.is64bit);
        m.append(this.lastModified);
        m.append(this.obtainedFrom);
    }

    @Override
    public void loadFromMessage(Message m, byte version) {
        super.loadFromMessage(m, version);
        this.type = m.getNextByte();
        this.is64bit = m.getNextByte();
        this.lastModified = m.getNextLong();
        this.obtainedFrom = m.getNextByte();
    }

    public boolean isSystemApp() {
        return this.path.startsWith("/System");
    }

    public String getType() {
        switch (this.type) {
            case 1: {
                return "PPC";
            }
            case 2: {
                return "Intel";
            }
        }
        return "Unknown";
    }
}

