/*
 * Decompiled with CFR 0.152.
 */
package utils.software;

import java.util.Date;
import utils.message.Message;
import utils.ostools.OS;
import utils.software.linux.LinuxSoftware;
import utils.software.macos.OSXApplication;
import utils.software.macos.OSXSoftware;
import utils.software.macos.OSXUpdate;
import utils.software.types.AbstractApplication;
import utils.software.types.AbstractUpdate;
import utils.software.types.software.AbstractSoftware;
import utils.software.types.software.Software;
import utils.software.windows.WindowsApplication;
import utils.software.windows.WindowsHotFix;
import utils.software.windows.WindowsSoftware;
import utils.software.windows.WindowsUpdate;

public class OSSoftwareUtil {
    public static Software getOSSoftware() {
        return OSSoftwareUtil.getOSSoftware(true);
    }

    public static Software getOSSoftware(boolean currentlyInstalled) {
        AbstractSoftware software = null;
        if (OS.isWindows()) {
            software = new WindowsSoftware();
        } else if (OS.isMacOS()) {
            software = new OSXSoftware();
        } else if (OS.isLinux()) {
            software = new LinuxSoftware();
        }
        if (software == null) {
            return null;
        }
        if (currentlyInstalled) {
            ((AbstractSoftware)software).updateCurrentlyInstalledApps();
        } else {
            ((AbstractSoftware)software).updatePreviouslyInstalledApps();
        }
        return software;
    }

    public static String softwareToString(Software<? extends AbstractApplication, ? extends AbstractUpdate> software) {
        if (software == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (AbstractApplication abstractApplication : software.getApplications()) {
            builder.append(abstractApplication.applicationName).append(":\n");
            builder.append("\tVersion: ").append(abstractApplication.appVersion).append("\n");
            if (abstractApplication.description != null) {
                builder.append("\tDescription: ").append(abstractApplication.description).append("\n");
            }
            if (abstractApplication.path != null) {
                builder.append("\tLocation: ").append(abstractApplication.path).append("\n");
            }
            if (abstractApplication.vendor != null) {
                builder.append("\tVendor: ").append(abstractApplication.vendor).append("\n");
            }
            if (abstractApplication instanceof OSXApplication) {
                OSXApplication osxApp = (OSXApplication)abstractApplication;
                switch (((OSXApplication)abstractApplication).obtainedFrom) {
                    case 0: {
                        builder.append("\tObtained From: Unknown").append("\n");
                        break;
                    }
                    case 1: {
                        builder.append("\tObtained From: Apple").append("\n");
                        break;
                    }
                    case 3: {
                        builder.append("\tObtained From: Other").append("\n");
                    }
                }
                if (osxApp.type != 0) {
                    builder.append("\tKind: ").append(osxApp.getType()).append("\n");
                }
                if (osxApp.is64bit != 0) {
                    builder.append("\t64Bit: ").append(osxApp.is64bit == 1 ? "Yes" : "No").append("\n");
                }
                builder.append("\tLast Modified: ").append(osxApp.lastModified).append("\n");
            } else if (abstractApplication instanceof WindowsApplication) {
                WindowsApplication winApp = (WindowsApplication)abstractApplication;
                builder.append("\tInstallDate: ").append(winApp.installDate).append("\n");
                builder.append("\tStatusCode: ").append(winApp.statusCode).append("\n");
            }
            builder.append("\n");
        }
        for (AbstractUpdate abstractUpdate : software.getUpdates()) {
            builder.append(abstractUpdate.name).append(":\n");
            builder.append("\tID: ").append(abstractUpdate.id).append("\n");
            if (abstractUpdate.updateVersion != null) {
                builder.append("\tVersion: ").append(abstractUpdate.updateVersion).append("\n");
            }
            builder.append("\tRestart: ").append(abstractUpdate.restartRequired).append("\n");
            if (abstractUpdate instanceof WindowsUpdate) {
                WindowsUpdate wapp = (WindowsUpdate)abstractUpdate;
                builder.append("\tSeverity: ").append(wapp.severity).append("\n");
                builder.append("\tDescription: ").append(wapp.description).append("\n");
            } else if (abstractUpdate instanceof OSXUpdate) {
                OSXUpdate osxUpdate = (OSXUpdate)abstractUpdate;
                builder.append("\tSize: ").append(osxUpdate.sizeBytes).append("\n");
            }
            builder.append("\n");
        }
        if (software instanceof WindowsSoftware) {
            for (WindowsHotFix windowsHotFix : ((WindowsSoftware)software).getHotFixes()) {
                builder.append(windowsHotFix.description).append(" ").append(windowsHotFix.hotFixID).append("\n");
                builder.append("\tInstalledOn: ").append(new Date(windowsHotFix.installedOn)).append("\n");
                builder.append("\tKBArticle: ").append(windowsHotFix.caption).append("\n");
            }
        }
        return builder.toString();
    }

    public static Message toMessage(Software software) {
        Message m = null;
        if (software instanceof WindowsSoftware) {
            m = new Message(0);
        } else if (software instanceof LinuxSoftware) {
            m = new Message(2);
        } else if (software instanceof OSXSoftware) {
            m = new Message(1);
        }
        software.saveToMessage(m);
        return m;
    }

    public static Software fromMessage(Message m) {
        AbstractSoftware software = null;
        if (m.getType() == 0) {
            software = new WindowsSoftware();
        } else if (m.getType() == 2) {
            software = new LinuxSoftware();
        } else if (m.getType() == 1) {
            software = new OSXSoftware();
        }
        if (software != null) {
            software.loadFromMessage(m);
        }
        return software;
    }
}

