/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools.streams;

import java.io.IOException;
import java.io.InputStream;

public class BitInputStream
extends InputStream {
    private InputStream myInput;
    private int myBitCount;
    private int myBuffer;
    private static final int[] bmask = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};
    private static final int BITS_PER_BYTE = 8;

    public BitInputStream(InputStream in) {
        this.myInput = in;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.myInput != null) {
                this.myInput.close();
            }
        }
        finally {
            super.close();
        }
    }

    public int readBits(int howManyBits) throws IOException {
        int retval = 0;
        if (this.myInput == null) {
            return -1;
        }
        while (howManyBits > this.myBitCount) {
            retval |= this.myBuffer << howManyBits - this.myBitCount;
            howManyBits -= this.myBitCount;
            this.myBuffer = this.myInput.read();
            if (this.myBuffer == -1) {
                return -1;
            }
            this.myBitCount = 8;
        }
        if (howManyBits > 0) {
            retval |= this.myBuffer >> this.myBitCount - howManyBits;
            this.myBuffer &= bmask[this.myBitCount - howManyBits];
            this.myBitCount -= howManyBits;
        }
        return retval;
    }

    public boolean haveReadEntireByte() {
        return this.myBitCount == 0;
    }

    @Override
    public int read() throws IOException {
        return this.readBits(8);
    }

    public void clearBuffer() {
        this.myBitCount = 0;
    }
}

