/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import utils.progtools.TimeoutMapListener;
import utils.progtools.WeakReferenceTimerThread;
import utils.progtools.clock.AltClock;
import utils.progtools.clock.TimingAltClock;

public class TimeoutMap<K, V>
implements Runnable {
    protected Random random = new Random();
    private final Object LOCK = new Object();
    private HashMap<K, Timed<V>> map = new HashMap();
    private AltClock clock;
    private WeakReferenceTimerThread wrt;
    private int cleanupMS;

    public TimeoutMap() {
        this((AltClock)new TimingAltClock());
    }

    public TimeoutMap(int cleanupMS) {
        this((AltClock)new TimingAltClock(), cleanupMS);
    }

    public TimeoutMap(AltClock clock) {
        this(clock, 30000);
    }

    public TimeoutMap(AltClock clock, int cleanupMS) {
        this.cleanupMS = cleanupMS;
        this.clock = clock;
        this.wrt = new WeakReferenceTimerThread((Runnable)this, cleanupMS);
        this.wrt.start();
    }

    @Override
    public void run() {
        try {
            this.cleanup();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K[] keySetArray(K[] array) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.map.keySet().toArray(array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        ArrayList<Cleanup> cleanups = null;
        Iterator iterator = this.LOCK;
        synchronized (iterator) {
            if (this.map.size() > 0) {
                HashSet<K> keys = new HashSet<K>(this.map.keySet());
                long T = this.clock.getTime();
                for (Object key : keys) {
                    Timed<V> t = this.map.get(key);
                    if (t != null) {
                        if (T <= t.timeout) continue;
                        Timed<V> val = this.map.remove(key);
                        if (t.listener == null) continue;
                        if (cleanups == null) {
                            cleanups = new ArrayList<Cleanup>();
                        }
                        cleanups.add(new Cleanup(key, val.o, t.listener));
                        continue;
                    }
                    this.map.remove(key);
                }
            } else if (this.cleanupMS < 5000) {
                try {
                    this.LOCK.wait(5000L);
                }
                catch (InterruptedException keys) {
                    // empty catch block
                }
            }
        }
        if (cleanups != null) {
            for (Cleanup cleanup : cleanups) {
                try {
                    cleanup.listener.objectTimedOut(cleanup.key, cleanup.value);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        Object object = this.LOCK;
        synchronized (object) {
            Timed<V> t = this.map.remove(key);
            if (t == null) {
                return null;
            }
            return t.o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        Object object = this.LOCK;
        synchronized (object) {
            Timed<V> t = this.map.get(key);
            if (t == null) {
                return null;
            }
            return t.o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key, long refreshTimeout) {
        Object object = this.LOCK;
        synchronized (object) {
            Timed<V> t = this.map.get(key);
            if (t == null) {
                return null;
            }
            t.timeout = this.clock.getTime() + refreshTimeout;
            return t.o;
        }
    }

    public void put(K key, V value, long timeout) {
        this.put(key, value, timeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value, long timeout, TimeoutMapListener<K, V> listener) {
        Object object = this.LOCK;
        synchronized (object) {
            Timed<V> t = this.map.get(key);
            if (t == null) {
                t = new Timed();
                t.o = value;
                t.timeout = this.clock.getTime() + timeout;
                t.listener = listener;
                this.map.put(key, t);
            } else {
                t.o = value;
                t.timeout = this.clock.getTime() + timeout;
                t.listener = listener;
            }
            this.LOCK.notifyAll();
        }
    }

    public static void main(String[] args) throws Exception {
        Thread.sleep(2000L);
        NoKeyTimeoutMap<Integer> map = new NoKeyTimeoutMap<Integer>(new TimingAltClock(), 150);
        System.out.println("Map on");
        Thread.sleep(2000L);
        for (int i = 0; i < 20; ++i) {
            System.out.println("Adding " + i);
            map.add(i, 10000L, new TestTimeout(map));
            Thread.sleep(1000L);
        }
    }

    private class Cleanup {
        private K key;
        private V value;
        private TimeoutMapListener<K, V> listener;

        public Cleanup(K key, V value, TimeoutMapListener<K, V> listener) {
            this.key = key;
            this.value = value;
            this.listener = listener;
        }
    }

    public static class NoKeyTimeoutMap<V>
    extends TimeoutMap<String, V> {
        public NoKeyTimeoutMap(int cleanupMS) {
            super(cleanupMS);
        }

        public NoKeyTimeoutMap() {
        }

        public NoKeyTimeoutMap(TimingAltClock timingAltClock, int cleanupMS) {
            super((AltClock)timingAltClock, cleanupMS);
        }

        public void add(V value, long timeout, TimeoutMapListener<String, V> listener) {
            String key = this.random.nextLong() + "_" + this.random.nextLong();
            this.put(key, value, timeout, listener);
        }
    }

    static class TestTimeout
    implements TimeoutMapListener<String, Integer> {
        TimeoutMap map;

        public TestTimeout(TimeoutMap map) {
            this.map = map;
        }

        @Override
        public void objectTimedOut(String key, Integer val) {
            System.out.println("TIMED OUT: " + key + " = " + val + " (map size: " + this.map.size() + ")");
        }
    }

    class Timed<V> {
        V o;
        long timeout;
        TimeoutMapListener<K, V> listener;

        Timed() {
        }
    }
}

