/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

public abstract class RobustThread {
    WorkerThread worker;

    public void start() {
        MonitorThread mt = new MonitorThread();
        mt.start();
    }

    public abstract String getRobustName();

    public abstract boolean isShutdown();

    public abstract void reInit() throws Throwable;

    public abstract void robustRun() throws Throwable;

    public static void main(String[] args) {
        new Test().start();
    }

    class MonitorThread
    extends Thread {
        MonitorThread() {
        }

        @Override
        public void run() {
            while (!RobustThread.this.isShutdown()) {
                if (RobustThread.this.worker != null && !RobustThread.this.worker.isAlive()) {
                    System.out.println("[RobustThread] " + RobustThread.this.getRobustName() + " has died, relaunching");
                    RobustThread.this.worker = null;
                }
                if (RobustThread.this.worker == null) {
                    System.out.println("[RobustThread] " + RobustThread.this.getRobustName() + " launching now");
                    RobustThread.this.worker = new WorkerThread();
                    RobustThread.this.worker.start();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
        }
    }

    static class Test
    extends RobustThread {
        long max = System.currentTimeMillis() + 20000L;

        Test() {
        }

        @Override
        public String getRobustName() {
            return "RobustThreadTest";
        }

        @Override
        public boolean isShutdown() {
            return System.currentTimeMillis() > this.max;
        }

        @Override
        public void reInit() throws Throwable {
            System.out.println("Test reiniting...");
        }

        @Override
        public void robustRun() throws Throwable {
            System.out.println("Test running...");
            Thread.sleep(2000L);
        }
    }

    class WorkerThread
    extends Thread {
        WorkerThread() {
        }

        @Override
        public void run() {
            try {
                RobustThread.this.reInit();
            }
            catch (Throwable t) {
                System.out.println("[RobustThread] init failed: " + t);
                t.printStackTrace();
            }
            try {
                RobustThread.this.robustRun();
            }
            catch (Throwable t) {
                System.out.println("[RobustThread] run failed: " + t);
                t.printStackTrace();
            }
        }
    }
}

