/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.lang.reflect.Field;
import utils.progtools.Cleanable;

public class MemoryCleaner {
    public static void cleanAndNullifyAll(Object o) {
        try {
            Field[] fields;
            for (Field field : fields = o.getClass().getDeclaredFields()) {
                System.out.println("[Cleaner] Cleaning field " + field.getName() + " in " + o.getClass().getName());
                try {
                    field.setAccessible(true);
                    Object fieldObj = field.get(o);
                    if (fieldObj instanceof Cleanable) {
                        try {
                            ((Cleanable)fieldObj).cleanupNow();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    field.set(o, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void cleanThreads(ThreadGroup threadGroup) {
        int count = threadGroup.activeCount();
        Thread[] threads = new Thread[count * 3];
        threadGroup.enumerate(threads, true);
        for (Thread thread : threads) {
            MemoryCleaner.cleanThread(thread);
        }
    }

    public static void cleanThread(Thread thread) {
        if (thread instanceof Cleanable) {
            System.out.println("[Cleanable] Cleaning thread " + thread);
            try {
                ((Cleanable)thread).cleanupNow();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

