/*
 * Decompiled with CFR 0.152.
 */
package utils.ostools.debug;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;

public class ThreadCountPrinter
extends Thread {
    static final int SLEEP_DEFAULT = 60000;
    static ThreadCountPrinter INSTANCE = null;
    static final Object LOCK = new Object();
    private static SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy HH:mm:SS");
    private boolean die = false;
    private int sleep;
    DecimalFormat df = new DecimalFormat("###,###,###,###,##0");
    DecimalFormat df2 = new DecimalFormat("###,###,###,###,##0.0");
    double peakUsedPc;

    public ThreadCountPrinter(int sleep) {
        this.sleep = sleep;
    }

    public static void main(String[] args) {
        ThreadCountPrinter.countThreads(10000);
    }

    public static void countThreads() {
        ThreadCountPrinter.countThreads(60000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void countThreads(int sleep) {
        Object object = LOCK;
        synchronized (object) {
            if (INSTANCE != null) {
                ThreadCountPrinter.INSTANCE.die = true;
            }
            if (INSTANCE == null) {
                INSTANCE = new ThreadCountPrinter(sleep);
                INSTANCE.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void die() {
        Object object = LOCK;
        synchronized (object) {
            if (INSTANCE != null) {
                ThreadCountPrinter.INSTANCE.die = true;
            }
        }
    }

    @Override
    public void run() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        while (!this.die) {
            String stdout;
            String[] result;
            String date = sdf.format(new Date(System.currentTimeMillis()));
            Runtime rt = Runtime.getRuntime();
            double total = rt.totalMemory();
            double free = rt.freeMemory();
            double max = rt.maxMemory();
            double used = total - free;
            double usedPc = 100.0 / max * used;
            String peak = "";
            if (usedPc > this.peakUsedPc) {
                this.peakUsedPc = usedPc;
                peak = " ^NewPeak " + this.df2.format(this.peakUsedPc) + "%";
            }
            System.out.println("[ProcessHealth][" + date + "] Memory Used [" + this.df2.format(usedPc) + "% / " + this.df.format(used / 1024.0) + "K of " + this.df.format(max / 1024.0) + "K" + peak + "] Threads [" + bean.getThreadCount() + " / max " + bean.getPeakThreadCount() + "]");
            if (OS.isWindows()) {
                result = RunCommandGetOutput.runCommandGetOutput((String[])new String[]{"cmd.exe", "/c", "netstat.exe -aon"});
                stdout = result[0];
            } else {
                result = RunCommandGetOutput.runCommandGetOutput((String[])new String[]{"/bin/sh", "-c", "netstat -an"});
                stdout = result[0];
            }
            if (stdout != null) {
                String[] lines = stdout.split("\n");
                int tcpListening = 0;
                int tcpEstablished = 0;
                int tcpTimeWait = 0;
                int tcpFinWait = 0;
                int udp = 0;
                for (String line : lines) {
                    if ((line = line.trim().toLowerCase()).startsWith("tcp")) {
                        if (line.contains("listen")) {
                            ++tcpListening;
                            continue;
                        }
                        if (line.contains("established")) {
                            ++tcpEstablished;
                            continue;
                        }
                        if (line.contains("time_wait")) {
                            ++tcpTimeWait;
                            continue;
                        }
                        if (!line.contains("fin_wait") && !line.contains("close_wait")) continue;
                        ++tcpFinWait;
                        continue;
                    }
                    if (!line.startsWith("udp")) continue;
                    ++udp;
                }
                System.out.println("[ProcessHealth][" + date + "] OS Sockets  [listen " + tcpListening + ", established " + tcpEstablished + ", wait " + tcpTimeWait + ", close " + tcpFinWait + ", udp " + udp + "]");
            }
            try {
                Thread.sleep(this.sleep);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

