/*
 * Decompiled with CFR 0.152.
 */
package utils.multiplex;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import utils.stream.OpenBoutPool;
import utils.stream.OpenByteArrayOutputStream;

public class FastBoutBuffer
extends InputStream {
    public static final int INFINITE_BUFFER = -1;
    public static final int DEFAULT_BUFFER = 400000;
    Object buffer_LOCK = new Object();
    LinkedList<OpenByteArrayOutputStream> bufs = new LinkedList();
    int len = 0;
    OpenBoutPool datapool;
    OpenByteArrayOutputStream datasource;
    byte[] databuffer = new byte[0];
    int datalen = 0;
    int ptr = 0;
    boolean closed = false;
    IOException ioexception = null;
    boolean waiting_for_data = false;
    boolean waiting_for_space = false;
    int max_buffer = 400000;
    String name;

    public FastBoutBuffer(int max_buffer, OpenBoutPool pool) {
        this.max_buffer = max_buffer;
        this.datapool = pool;
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int length() {
        Object object = this.buffer_LOCK;
        synchronized (object) {
            return this.len + (this.datalen - this.ptr);
        }
    }

    private void waitForData() {
        while (this.len <= 0 && !this.closed) {
            try {
                this.waiting_for_data = true;
                this.buffer_LOCK.wait();
                this.waiting_for_data = false;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClosed() {
        this.closed = true;
        Object object = this.buffer_LOCK;
        synchronized (object) {
            if (this.waiting_for_data) {
                this.buffer_LOCK.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClosed(IOException t) {
        this.closed = true;
        this.ioexception = t;
        Object object = this.buffer_LOCK;
        synchronized (object) {
            if (this.waiting_for_data) {
                this.buffer_LOCK.notifyAll();
            }
        }
    }

    private void throwIoException() throws IOException {
        if (this.ioexception != null) {
            IOException e = new IOException(this.ioexception.getMessage());
            e.initCause(this.ioexception);
            throw e;
        }
    }

    @Override
    public int read() throws IOException {
        byte[] dat = new byte[1];
        while (this.read(dat) == 0) {
        }
        return 0xFF & dat[0];
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int length) throws IOException {
        Object object = this.buffer_LOCK;
        synchronized (object) {
            if (this.closed && this.len == 0) {
                this.throwIoException();
                return -1;
            }
            this.get();
            if (this.closed && this.len == 0) {
                this.throwIoException();
                return -1;
            }
            int tmplen = this.datalen - this.ptr;
            if (tmplen <= length) {
                System.arraycopy(this.databuffer, this.ptr, b, off, tmplen);
                this.ptr += tmplen;
                return tmplen;
            }
            System.arraycopy(this.databuffer, this.ptr, b, off, length);
            this.ptr += length;
            return length;
        }
    }

    private void get() {
        if (this.ptr >= this.datalen) {
            this.waitForData();
            if (!this.closed || this.len > 0) {
                if (this.datasource != null) {
                    this.datapool.done((Object)this.datasource);
                }
                this.datasource = this.bufs.removeFirst();
                this.databuffer = this.datasource.getByteArray();
                this.datalen = this.datasource.size();
                this.len -= this.datalen;
                this.ptr = 0;
            }
            if (this.waiting_for_space) {
                this.buffer_LOCK.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(OpenByteArrayOutputStream source) {
        if (source.size() > 0) {
            Object object = this.buffer_LOCK;
            synchronized (object) {
                while (source.size() + this.len + (this.datalen - this.ptr) > this.max_buffer && this.len > 0 && this.max_buffer >= 0) {
                    this.waiting_for_space = true;
                    try {
                        this.buffer_LOCK.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.waiting_for_space = false;
                }
                this.bufs.addLast(source);
                this.len += source.size();
                if (this.waiting_for_data) {
                    this.buffer_LOCK.notify();
                }
            }
        }
    }
}

