/*
 * Decompiled with CFR 0.152.
 */
package utils.loggingframework.ui;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.RootPaneContainer;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.targets.AbstractTarget;
import utils.loggingframework.targets.LocatableTarget;
import utils.loggingframework.targets.TargetRepository;
import utils.loggingframework.targets.TargetUI;
import utils.loggingframework.targets.TargetUIListener;
import utils.loggingframework.targets.donothing.DoNothing;
import utils.loggingframework.ui.MultipleSelectTargetComponent;
import utils.swing.SwingStyleInterface;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.components.JWrapLabel;
import utils.swing.components.SHComboBox;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.layout.GbPanel;

public class SelectTargetComponent
implements ActionListener {
    private final Class[] targetsToFilterOut;
    private final boolean showRemove;
    private SHComboBox scopeBox;
    private SHComboBox targetBox;
    private JToggleButton configureButton;
    private JButton removeButton;
    private GbPanel targetPanel;
    private JWrapLabel descriptionLabel = new JWrapLabel();
    private JPanel configurationPanel;
    private GbPanel rootComponent;
    private TargetUI currentUI;
    private TargetUIListener canProceedListener;
    private LogEvent[] eventsToTarget = null;
    private SwingStyleInterface style;
    private boolean initialising;
    private ResourceBundle bundle;
    private AbstractTarget currentSelection;
    private boolean showPerMachineOption;

    public SelectTargetComponent(ResourceBundle bundle, TargetUIListener canProceedListener, SwingStyleInterface style, boolean showPerMachineOption, Class[] targetsToFilterOut) {
        this.canProceedListener = canProceedListener;
        this.style = style;
        this.bundle = bundle;
        this.showPerMachineOption = showPerMachineOption;
        this.targetsToFilterOut = targetsToFilterOut;
        this.showRemove = canProceedListener instanceof MultipleSelectTargetComponent.MultiTargetUIListener;
        this.initUI();
    }

    public void load(AbstractTarget target) {
        this.initialising = true;
        try {
            this.currentSelection = target;
            if (target != null) {
                this.targetBox.setSelectedItem((Object)target);
                this.setSelectedTarget(target);
            } else {
                this.targetBox.setSelectedIndex(0);
            }
            this.targetBox.repaint();
            if (this.showPerMachineOption) {
                if (target instanceof LocatableTarget) {
                    LocatableTarget locTarget = (LocatableTarget)((Object)target);
                    if (locTarget.runPerMachine()) {
                        this.scopeBox.setSelectedIndex(1);
                    } else {
                        this.scopeBox.setSelectedIndex(0);
                    }
                    if (locTarget.runPerMachineIsOptional()) {
                        this.scopeBox.setEnabled(true);
                    } else {
                        this.scopeBox.setEnabled(false);
                    }
                } else {
                    this.scopeBox.setSelectedIndex(0);
                    this.scopeBox.setEnabled(false);
                }
            } else {
                this.scopeBox.setVisible(false);
                this.scopeBox.setSelectedIndex(0);
            }
        }
        finally {
            this.initialising = false;
        }
    }

    public void setLogEventsToTarget(LogEvent[] eventsToTarget) {
        if (this.eventsToTarget != null && Arrays.equals(eventsToTarget, this.eventsToTarget)) {
            return;
        }
        AbstractTarget[] targetInstances = this.filterTargetInstances(TargetRepository.INSTANCE.getTargetInstances(this.bundle));
        this.initTargetBox(targetInstances);
        this.eventsToTarget = eventsToTarget;
        if (this.currentUI != null) {
            this.currentUI.setEventsToTarget(eventsToTarget);
        }
    }

    private AbstractTarget[] filterTargetInstances(AbstractTarget[] targets) {
        if (this.targetsToFilterOut == null || this.targetsToFilterOut.length == 0) {
            return targets;
        }
        ArrayList<AbstractTarget> allTargets = new ArrayList<AbstractTarget>();
        for (AbstractTarget target : targets) {
            boolean ignore = false;
            for (Class c : this.targetsToFilterOut) {
                if (!target.getClass().equals(c)) continue;
                ignore = true;
                break;
            }
            if (ignore) continue;
            allTargets.add(target);
        }
        return allTargets.toArray(new AbstractTarget[0]);
    }

    private void initUI() {
        AbstractTarget[] targetInstances = this.filterTargetInstances(TargetRepository.INSTANCE.getTargetInstances(this.bundle));
        this.rootComponent = new ColorPropagatingGBPanel();
        this.rootComponent.setBorder(SHBorderFactory.createEmptyBorder((int)3, (int)3, (int)3, (int)3));
        this.configureButton = new JToggleButton(this.bundle.getString("CONFIGURE"));
        if (this.showRemove) {
            this.removeButton = new JButton(this.bundle.getString("REMOVE"));
            SHButtonUI.makeButtonRed((JButton)this.removeButton);
            this.removeButton.addActionListener(this);
        }
        this.scopeBox = new SHComboBox((Object[])new String[]{this.bundle.getString("ACTION_FOR_ONCE"), this.bundle.getString("ACTION_FOR_EVERY_MACHINE")});
        this.initTargetBox(targetInstances);
        this.initConfigurationPanel();
        this.initTargetPanel();
        JLabel label = new JLabel(this.bundle.getString("LOGGING_FRAMEWORK_ACTION"));
        int x = 0;
        this.rootComponent.add((Component)label, x++, 0, 1, 1, 0, 0, 13, 0, (Insets)new ScaledInsets(3, 3, 3, 3));
        this.rootComponent.add((Component)this.targetBox, x++, 0, 1, 1, 0, 0, 17, 3, (Insets)new ScaledInsets(3, 3, 3, 3));
        this.rootComponent.add((Component)this.scopeBox, x++, 0, 1, 1, 1, 0, 17, 3, (Insets)new ScaledInsets(3, 3, 3, 3));
        if (this.showRemove) {
            this.rootComponent.add((Component)this.removeButton, x++, 0, 1, 1, 0, 0, 13, 3, (Insets)new ScaledInsets(3, 3, 3, 3));
        }
        this.rootComponent.add((Component)this.configureButton, x++, 0, 1, 1, 0, 0, 13, 3, (Insets)new ScaledInsets(3, 3, 3, 3));
        this.rootComponent.add((Component)this.targetPanel, 0, 1, x, 1, 1, 1, 10, 1, (Insets)new ScaledInsets(3, 3, 3, 3));
        this.targetBox.addActionListener((ActionListener)this);
        this.scopeBox.addActionListener((ActionListener)this);
        this.configureButton.addActionListener(this);
        this.setShowConfiguration(false);
    }

    protected void setSelectedTarget(AbstractTarget target) {
        this.configureButton.setEnabled(!(target instanceof DoNothing));
        if (!this.initialising) {
            this.load(target);
        }
        this.descriptionLabel.setText(target.getDescription());
        this.currentUI = target.getTargetUI();
        this.currentUI.setResources(this.bundle, this.style);
        this.currentUI.setEventsToTarget(this.eventsToTarget);
        this.currentUI.addTargetUIListener(this.canProceedListener);
        this.currentUI.setEventsToTarget(this.eventsToTarget);
        this.currentUI.initWithTarget(target);
        if (this.currentUI.getRootComponent() != null) {
            this.currentUI.getRootComponent().repaint();
        }
        this.configurationPanel.removeAll();
        this.configurationPanel.add(this.currentUI.getRootComponent());
        this.currentUI.getRootComponent().setBackground(this.configurationPanel.getBackground());
        this.configurationPanel.revalidate();
        this.configurationPanel.repaint();
        if (!this.initialising) {
            this.currentUI.notifyIfComplete();
        }
        if (!this.initialising) {
            this.setShowConfiguration(true);
        }
        if (!(target instanceof LocatableTarget)) {
            this.scopeBox.setSelectedIndex(0);
            this.scopeBox.setEnabled(false);
        }
    }

    private void setShowConfiguration(boolean showConfiguration) {
        this.configureButton.setSelected(showConfiguration);
        showConfiguration = showConfiguration && !(this.currentSelection instanceof DoNothing);
        this.descriptionLabel.setVisible(showConfiguration);
        this.configurationPanel.setVisible(showConfiguration);
    }

    private void initTargetPanel() {
        this.targetPanel = new ColorPropagatingGBPanel(new ScaledInsets(4, 4, 4, 4));
        this.targetPanel.add((Component)this.descriptionLabel, 0, 1, 1, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(4, 4, 10, 4));
        this.targetPanel.add((Component)this.configurationPanel, 0, 2, 1, 1, 1, 100, 17, 1);
    }

    private void initConfigurationPanel() {
        this.configurationPanel = new ColorPropagatingPanel();
        this.configurationPanel.setLayout(new GridLayout());
    }

    private void initTargetBox(AbstractTarget[] targetInstances) {
        if (this.targetBox == null) {
            this.targetBox = new SHComboBox((Object[])targetInstances);
        } else {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.targetBox.getModel();
            ArrayList<AbstractTarget> removals = new ArrayList<AbstractTarget>();
            for (int i = 0; i < model.getSize(); ++i) {
                AbstractTarget targetInModel = (AbstractTarget)model.getElementAt(i);
                boolean found = false;
                for (AbstractTarget targetInstance : targetInstances) {
                    if (!targetInstance.equals(targetInModel)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                removals.add(targetInModel);
            }
            for (AbstractTarget target : removals) {
                model.removeElement(target);
            }
        }
    }

    public JComponent getComponent() {
        return this.rootComponent;
    }

    public AbstractTarget getSelectedAbstractTarget() {
        AbstractTarget target = (AbstractTarget)this.targetBox.getSelectedItem();
        if ((target = TargetRepository.INSTANCE.getNewTargetInstance(target)) instanceof LocatableTarget) {
            ((LocatableTarget)((Object)target)).setRunPerMachine(this.scopeBox.getSelectedIndex() == 1);
        }
        if (this.currentUI != null) {
            this.currentUI.populateTarget(target);
        }
        return target;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.removeButton) {
            boolean remove = SHGlassOptionPane.showOkCancelDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)this.rootComponent), (String)this.bundle.getString("REMOVE_ACTION_MSG"), (String)this.bundle.getString("REMOVE_ACTION_TITLE"), (Icon)this.style.getImageIcon("images/svg/dialogs/warning.svg,48"), (String)this.bundle.getString("REMOVE"), (String)this.bundle.getString("CANCEL"));
            if (remove && this.canProceedListener instanceof MultipleSelectTargetComponent.MultiTargetUIListener) {
                ((MultipleSelectTargetComponent.MultiTargetUIListener)this.canProceedListener).remove(this);
            }
        } else if (e.getSource() == this.targetBox) {
            if (!this.initialising) {
                AbstractTarget target = (AbstractTarget)this.targetBox.getSelectedItem();
                this.setSelectedTarget(target);
            }
        } else if (e.getSource() == this.scopeBox) {
            if (!this.initialising && this.currentSelection != null && this.currentSelection instanceof LocatableTarget) {
                ((LocatableTarget)((Object)this.currentSelection)).setRunPerMachine(this.scopeBox.getSelectedIndex() == 1);
                if (this.currentUI != null) {
                    this.currentUI.notifyIfComplete();
                }
            }
        } else if (e.getSource() == this.configureButton) {
            this.setShowConfiguration(this.configureButton.isSelected());
        }
    }
}

