/*
 * Decompiled with CFR 0.152.
 */
package utils.loggingframework.targets.httppost;

import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import utils.loggingframework.targets.AbstractTarget;
import utils.loggingframework.targets.AbstractTargetUI;
import utils.loggingframework.targets.httppost.HTTPPostTarget;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class HTTPPostTargetUI
extends AbstractTargetUI {
    private ColorPropagatingGBPanel rootComponent = new ColorPropagatingGBPanel();
    private JLabel postURLLabel = new JLabel();
    private JTextField postURLField = new JTextField();
    private JRadioButton postAsXML = new JRadioButton();
    private JRadioButton postAsEncoded = new JRadioButton();
    private ButtonGroup group;

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public void notifyIfComplete() {
        if (this.postURLField.getText().length() > 0) {
            this.notifyComplete();
        } else {
            this.notifyIncomplete();
        }
    }

    @Override
    public JComponent getRootComponent() {
        return this.rootComponent;
    }

    @Override
    protected void initUI() {
        this.postURLLabel.setText(this.bundle.getString("TARGET_UI_HTTPPOST_URL"));
        this.postAsXML.setText(this.bundle.getString("TARGET_UI_HTTPPOST_XML"));
        this.postAsEncoded.setText(this.bundle.getString("TARGET_UI_HTTPPOST_ENCODED"));
        this.rootComponent.add(this.postURLLabel, 0, 0, 1, 1, 0, 1, 13, 0, (Insets)new ScaledInsets(3, 3, 3, 3));
        this.rootComponent.add(this.postURLField, 1, 0, 1, 1, 1, 1, 17, 0, (Insets)new ScaledInsets(3, 3, 3, 3));
        this.rootComponent.add(this.postAsXML, 0, 1, 2, 1, 0, 1, 17, 0, (Insets)new ScaledInsets(10, 3, 3, 3));
        this.rootComponent.add(this.postAsEncoded, 0, 2, 2, 1, 0, 1, 17, 0, (Insets)new ScaledInsets(0, 3, 3, 3));
        this.postURLField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                HTTPPostTargetUI.this.notifyIfComplete();
                HTTPPostTargetUI.this.notifyChanged();
            }
        });
        this.group = new ButtonGroup();
        this.group.add(this.postAsXML);
        this.group.add(this.postAsEncoded);
        this.postAsXML.setSelected(true);
        SwingUtil.setWidth((JComponent)this.postURLField, (int)SimpleHelpLookAndFeel.scale((int)350));
    }

    @Override
    public void populateTarget(AbstractTarget target) {
        if (!(target instanceof HTTPPostTarget)) {
            return;
        }
        HTTPPostTarget postTarget = (HTTPPostTarget)target;
        postTarget.postAsXML = this.postAsXML.isSelected();
        postTarget.postURL = this.postURLField.getText();
    }

    @Override
    public void initWithTarget(AbstractTarget target) {
        if (!(target instanceof HTTPPostTarget)) {
            return;
        }
        HTTPPostTarget et = (HTTPPostTarget)target;
        this.postURLField.setText(et.postURL);
        if (et.postAsXML) {
            this.group.setSelected(this.postAsXML.getModel(), true);
        } else {
            this.group.setSelected(this.postAsEncoded.getModel(), true);
        }
    }
}

