/*
 * Decompiled with CFR 0.152.
 */
package utils.loggingframework.targets.httppost;

import java.io.BufferedInputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.w3c.dom.Element;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.targets.AbstractTarget;
import utils.loggingframework.targets.LocatableTarget;
import utils.loggingframework.targets.TargetUI;
import utils.loggingframework.targets.httppost.HTTPPostTargetUI;
import utils.message.Message;
import utils.xml.XML14Util;

public class HTTPPostTarget
extends AbstractTarget
implements LocatableTarget {
    public boolean postAsXML = false;
    public boolean perMachine;
    public static final String ID = "HTTPPostTarget";
    public String postURL = null;

    @Override
    public String getName() {
        return this.bundle.getString("HTTP_POST_TARGET_NAME");
    }

    @Override
    public String getDescription() {
        return this.bundle.getString("HTTP_POST_TARGET_DESC");
    }

    @Override
    public String getTargetSummary() {
        if (this.postURL != null && this.postURL.length() > 0) {
            return this.getName() + " [" + this.postURL + "]";
        }
        return this.getName();
    }

    public static String getURLEncodingOfEvent(LogEvent event) throws Exception {
        StringBuffer buffer = new StringBuffer();
        Properties properties = event.toProperties();
        Set<Object> keyset = properties.keySet();
        Iterator<Object> keyIterator = keyset.iterator();
        boolean first = true;
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            String value = properties.getProperty(key);
            if (value == null) continue;
            if (!first) {
                buffer.append("&");
            }
            buffer.append(URLEncoder.encode(key, "UTF-8")).append("=").append(URLEncoder.encode(value, "UTF-8"));
            first = false;
        }
        return buffer.toString();
    }

    @Override
    public void logEvent(LogEvent event) throws Exception {
        URL url = new URL(this.postURL);
        URLConnection con = url.openConnection();
        con.setDoInput(true);
        con.setDoOutput(true);
        con.setConnectTimeout(20000);
        con.setReadTimeout(20000);
        con.setUseCaches(false);
        if (this.postAsXML) {
            con.setRequestProperty("Content-Type", "text/xml; charset=UTF-8");
        } else {
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        }
        OutputStream out = con.getOutputStream();
        if (this.postAsXML) {
            out.write(event.toXML().getBytes(StandardCharsets.UTF_8));
        } else {
            out.write(HTTPPostTarget.getURLEncodingOfEvent(event).getBytes(StandardCharsets.UTF_8));
        }
        out.flush();
        BufferedInputStream in = new BufferedInputStream(con.getInputStream());
        int readCount = 0;
        while (in.read() != -1) {
            ++readCount;
        }
        in.close();
        out.close();
        System.out.println("[HTTPPostTarget] Sent event data to '" + this.postURL + "' and got response (" + readCount + " bytes).");
    }

    @Override
    public TargetUI getTargetUI() {
        return new HTTPPostTargetUI();
    }

    @Override
    public boolean isAvailableTarget() {
        return true;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    protected void saveToXML(StringBuffer buffer, int indent) {
        buffer.append(XML14Util.getIndent((int)indent)).append("<").append(this.getID()).append(">\n");
        XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"postURL", (String)this.postURL);
        XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"postAsXML", (String)Boolean.toString(this.postAsXML));
        XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"runPerMachine", (String)("" + this.perMachine));
        buffer.append(XML14Util.getIndent((int)indent)).append("</").append(this.getID()).append(">\n");
    }

    @Override
    protected void loadFromXML(Element root) {
        this.postURL = XML14Util.getChildText((Element)root, (String)"postURL", null);
        try {
            this.postAsXML = Boolean.parseBoolean(XML14Util.getChildText((Element)root, (String)"postAsXML", null));
        }
        catch (Throwable t) {
            this.postAsXML = false;
        }
        try {
            this.perMachine = XML14Util.getChildText((Element)root, (String)"runPerMachine", null).equalsIgnoreCase("true");
        }
        catch (Throwable t) {
            this.perMachine = false;
        }
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.postURL);
        m.append(this.postAsXML);
        m.append(this.perMachine);
    }

    @Override
    public void fromMessage(byte verison, Message m) {
        this.postURL = m.getNextString();
        this.postAsXML = m.getNextBoolean();
        if (m.hasNext()) {
            this.perMachine = m.getNextBoolean();
        }
    }

    @Override
    public boolean runPerMachineIsOptional() {
        return true;
    }

    @Override
    public boolean runPerMachine() {
        return this.perMachine;
    }

    @Override
    public void setRunPerMachine(boolean b) {
        this.perMachine = b;
    }
}

