/*
 * Decompiled with CFR 0.152.
 */
package utils.loggingframework.targets.file;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.w3c.dom.Element;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.targets.AbstractTarget;
import utils.loggingframework.targets.LocatableTarget;
import utils.loggingframework.targets.TargetUI;
import utils.loggingframework.targets.file.FileTargetUI;
import utils.message.Message;
import utils.xml.XML14Util;

public class FileTarget
extends AbstractTarget
implements LocatableTarget {
    public String logFileName = null;
    public String logFileLocation = null;
    public boolean timestamp = true;
    public boolean logAsXML = false;
    public boolean perMachine;
    public static final String ID = "FileTarget";

    @Override
    public String getName() {
        return this.bundle.getString("FILE_TARGET_NAME");
    }

    @Override
    public String getDescription() {
        return this.bundle.getString("FILE_TARGET_DESC");
    }

    @Override
    public String getTargetSummary() {
        if (this.logFileName != null) {
            return this.getName() + " [" + this.logFileName + "]";
        }
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logEvent(LogEvent event) throws Exception {
        File logLocation;
        File targetFile;
        String logFile = this.logFileLocation;
        if (this.logFileLocation == null || this.logFileLocation.length() == 0) {
            this.logFileLocation = "./";
        }
        try (BufferedOutputStream fout = (targetFile = new File(logLocation = new File(logFile), this.logFileName)).exists() ? new BufferedOutputStream(new FileOutputStream(targetFile, true)) : new BufferedOutputStream(new FileOutputStream(targetFile));){
            if (!this.logAsXML) {
                String logLine = event.getLogText().trim() + "\r\n";
                if (this.timestamp) {
                    logLine = this.getTimeStamp() + logLine;
                }
                ((OutputStream)fout).write(logLine.getBytes(StandardCharsets.ISO_8859_1));
            } else {
                String logLine = event.toXML().trim() + "\r\n";
                ((OutputStream)fout).write(logLine.getBytes(StandardCharsets.ISO_8859_1));
            }
        }
    }

    @Override
    public TargetUI getTargetUI() {
        return new FileTargetUI();
    }

    @Override
    public boolean isAvailableTarget() {
        return true;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.logFileName);
        m.append(this.logFileLocation);
        m.append(this.timestamp);
        m.append(this.logAsXML);
        m.append(this.perMachine);
    }

    @Override
    public void fromMessage(byte verison, Message m) {
        this.logFileName = m.getNextString();
        this.logFileLocation = m.getNextString();
        this.timestamp = m.getNextBoolean();
        this.logAsXML = m.getNextBoolean();
        if (m.hasNext()) {
            this.perMachine = m.getNextBoolean();
        }
    }

    @Override
    protected void saveToXML(StringBuffer buffer, int indent) {
        buffer.append(XML14Util.getIndent((int)indent)).append("<").append(this.getID()).append(">\n");
        XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"ID", (String)this.getID());
        XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"logFileName", (String)this.logFileName);
        XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"logFileLocation", (String)this.logFileLocation);
        XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"timestamp", (String)Boolean.toString(this.timestamp));
        XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"logAsXML", (String)Boolean.toString(this.logAsXML));
        XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"runPerMachine", (String)("" + this.perMachine));
        buffer.append(XML14Util.getIndent((int)indent)).append("</").append(this.getID()).append(">\n");
    }

    @Override
    protected void loadFromXML(Element root) {
        this.logFileName = XML14Util.getChildText((Element)root, (String)"logFileName", null);
        this.logFileLocation = XML14Util.getChildText((Element)root, (String)"logFileLocation", null);
        try {
            this.logAsXML = Boolean.parseBoolean(XML14Util.getChildText((Element)root, (String)"logAsXML", null));
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.logAsXML = false;
        }
        try {
            this.timestamp = Boolean.parseBoolean(XML14Util.getChildText((Element)root, (String)"timestamp", null));
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.timestamp = false;
        }
        try {
            this.perMachine = XML14Util.getChildText((Element)root, (String)"runPerMachine", null).equalsIgnoreCase("true");
        }
        catch (Throwable t) {
            this.perMachine = false;
        }
    }

    @Override
    public boolean runPerMachineIsOptional() {
        return true;
    }

    @Override
    public boolean runPerMachine() {
        return this.perMachine;
    }

    @Override
    public void setRunPerMachine(boolean b) {
        this.perMachine = b;
    }
}

