/*
 * Decompiled with CFR 0.152.
 */
package utils.loggingframework.targets.email;

import java.nio.charset.StandardCharsets;
import java.util.Random;
import org.w3c.dom.Element;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.targets.VariableUtil;
import utils.message.Message;
import utils.string.HexData;
import utils.xml.XML14Util;

public class EventEmailTemplate {
    public String eventType;
    public String subject;
    public String body;

    public String toString() {
        return "[EventEmailTemplate] for " + this.eventType;
    }

    public static EventEmailTemplate createTestTemplate() {
        Random r = new Random();
        EventEmailTemplate template = new EventEmailTemplate();
        template.eventType = Long.toString(r.nextLong());
        template.subject = Long.toString(r.nextLong());
        template.body = r.nextLong() + "\n" + r.nextLong() + "\n" + r.nextLong();
        return template;
    }

    public Object clone() {
        EventEmailTemplate t = new EventEmailTemplate();
        t.eventType = this.eventType;
        t.subject = this.subject;
        t.body = this.body;
        return t;
    }

    public boolean isForEvent(LogEvent event) {
        return this.eventType != null && this.eventType.equals(event.getEventType());
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setContent(String subject, String body) {
        this.subject = subject;
        this.body = body;
    }

    public String getBody() {
        return this.body;
    }

    public EventEmailTemplate() {
    }

    public boolean isHTML() {
        return this.body != null && this.body.length() > 6 && this.body.substring(0, 5).toUpperCase().startsWith("<HTML");
    }

    public EventEmailTemplate(LogEvent event) {
        this.eventType = event.getEventType();
    }

    public String getSubstitutedSubject(LogEvent event) {
        return VariableUtil.getSubstitutedText(this.subject, event);
    }

    public String getSubstitutedBody(LogEvent event) {
        return VariableUtil.getSubstitutedText(this.body, event);
    }

    public void toXML(StringBuffer buffer, int indent) {
        XML14Util.appendTextNode((StringBuffer)buffer, (int)indent, (String)"eventType", (String)this.eventType);
        XML14Util.appendTextNode((StringBuffer)buffer, (int)indent, (String)"subject", (String)this.subject);
        String hexBody = HexData.byteArrayToHexString((byte[])this.body.getBytes(StandardCharsets.UTF_8));
        buffer.append(XML14Util.getIndent((int)indent)).append("<body encoded=\"hex\">").append(hexBody).append("</body>\n");
    }

    public void loadFromXML(Element e) {
        this.eventType = XML14Util.getChildText((Element)e, (String)"eventType", null);
        this.subject = XML14Util.getChildText((Element)e, (String)"subject", null);
        Element bodyElement = XML14Util.getChild((Element)e, (String)"body");
        if (bodyElement.getAttribute("encoded") != null && bodyElement.getAttribute("encoded").equalsIgnoreCase("hex")) {
            String hex = XML14Util.getChildText((Element)e, (String)"body", null);
            this.body = new String(HexData.hexStringToByteArray((String)hex), StandardCharsets.UTF_8);
        } else {
            this.body = XML14Util.getChildText((Element)e, (String)"body", null);
        }
    }

    public Message toMessage() {
        Message m = new Message();
        m.append(this.eventType);
        m.append(this.subject);
        m.append(this.body);
        return m;
    }

    public static EventEmailTemplate fromMessage(Message m) {
        EventEmailTemplate template = new EventEmailTemplate();
        template.eventType = m.getNextString();
        template.subject = m.getNextString();
        template.body = m.getNextString();
        return template;
    }
}

