/*
 * Decompiled with CFR 0.152.
 */
package utils.loggingframework.events;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import utils.loggingframework.events.EventRepository;
import utils.loggingframework.events.VariableProcessor;
import utils.loggingframework.targets.email.EmailAddressMap;
import utils.xml.XML14Util;

public abstract class LogEvent {
    private static final DateFormat DATE_FORMAT = DateFormat.getDateInstance(3);
    private static final DateFormat TIME_FORMAT = DateFormat.getTimeInstance(2);
    public String date;
    public String time;
    public long timeMS;

    public abstract String getID();

    public abstract String getDisplayName();

    public abstract String getDescription();

    public abstract String getLogText();

    public String getValueForVariable(String variableID) {
        LogEventVariable[] variables;
        for (LogEventVariable v : variables = this.getVariables()) {
            if (!v.getId().toLowerCase().trim().equals(variableID.toLowerCase().trim())) continue;
            return v.getValue();
        }
        return null;
    }

    public LogEventVariable[] getVariables() {
        Field[] fields;
        ArrayList<LogEventVariable> variables = new ArrayList<LogEventVariable>();
        this.appendVariables(variables);
        for (Field f : fields = this.getClass().getDeclaredFields()) {
            Object value;
            Class<?> classType;
            VariableProcessor variableProcessor;
            if (Modifier.isPrivate(f.getModifiers()) || (variableProcessor = EventRepository.INSTANCE.getVariableProcessor(classType = f.getType())) == null) continue;
            try {
                value = f.get(this);
            }
            catch (Throwable t) {
                t.printStackTrace();
                continue;
            }
            variableProcessor.appendVariables(value, variables);
        }
        return variables.toArray(new LogEventVariable[0]);
    }

    protected void appendVariables(ArrayList<LogEventVariable> variableList) {
        variableList.add(new LogEventVariable("date", null, this.date));
        variableList.add(new LogEventVariable("time", null, this.time));
        variableList.add(new LogEventVariable("timeMS", null, this.timeMS));
    }

    public JPanel generateExtraConfigPanel() {
        return null;
    }

    public EmailAddressMap getPossibleEmailAddressesInEvent() {
        return null;
    }

    public LogEvent(long creationTime) {
        this.timeMS = creationTime;
        this.date = DATE_FORMAT.format(new Date(creationTime));
        this.time = TIME_FORMAT.format(new Date(creationTime));
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getEventType() {
        return this.getID();
    }

    public String toXML() throws IllegalArgumentException, IllegalAccessException {
        StringBuffer buffer = new StringBuffer();
        this.toXML(buffer, 0);
        return buffer.toString();
    }

    protected void addToXML(StringBuffer buffer, int indent) {
        XML14Util.appendTextNode((StringBuffer)buffer, (int)indent, (String)"date", (String)this.date);
        XML14Util.appendTextNode((StringBuffer)buffer, (int)indent, (String)"time", (String)this.time);
        XML14Util.appendTextNode((StringBuffer)buffer, (int)indent, (String)"timeMS", (String)Long.toString(this.timeMS));
    }

    protected void loadFromXML(Element root) {
        this.date = XML14Util.getChildText((Element)root, (String)"date", null);
        this.time = XML14Util.getChildText((Element)root, (String)"time", null);
        try {
            this.timeMS = Long.parseLong(XML14Util.getChildText((Element)root, (String)"timeMS", null));
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.timeMS = System.currentTimeMillis();
        }
    }

    protected abstract void toXML(StringBuffer var1, int var2);

    public Properties toProperties() {
        Properties properties = new Properties();
        this.toProperties(properties);
        return properties;
    }

    protected void safePut(Properties properties, Object key, Object value) {
        if (key != null && value != null) {
            properties.put(key, value);
        }
    }

    protected void toProperties(Properties properties) {
        this.safePut(properties, "date", this.date);
        this.safePut(properties, "time", this.time);
        this.safePut(properties, "timeMS", Long.toString(this.timeMS));
    }

    public static class LogEventVariable {
        String id;
        String name;
        String value;
        private String[] aliases;

        public String getId() {
            return this.id;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            return ((LogEventVariable)o).id.equals(this.id);
        }

        public String toString() {
            if (this.name != null) {
                return this.name;
            }
            return this.id;
        }

        public String getName() {
            if (this.name == null) {
                return this.id;
            }
            return this.name;
        }

        public LogEventVariable(String id, String name, String[] aliases, Object value) {
            this.id = id;
            this.name = name;
            this.aliases = aliases;
            this.value = value != null ? value + "" : null;
        }

        public LogEventVariable(String id, String name, Object value) {
            this(id, name, null, value);
        }

        public boolean isVariableFor(String id) {
            if (id.equals(this.id)) {
                return true;
            }
            if (this.aliases != null) {
                for (String s : this.aliases) {
                    if (!s.equals(id)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

